
<?php $__env->startSection('body'); ?>
    <section class="section-refine-search">
        <div class="container">
            <div class="row">
                <form method="GET" action="<?php echo e(route('front.ticket')); ?>" id="ticket-filter-form">
                    <div class="keyword col-sm-6 col-md-4">
                        <label>Search Keyword</label>
                        <input type="text" name="keyword" class="form-control hasclear" placeholder="Search"
                        value="<?php echo e($filters['keyword'] ?? ''); ?>">
                        <span class="clearer"><img src="<?php echo e(asset('assets/front/images/clear.png')); ?>" alt="image"></span>
                    </div>
                    <div class="location col-sm-6 col-md-3">
                        <label>Location</label>
                        <select name="country_id" class="selectpicker dropdown">
                            <option value="">Select Location</option>
                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country['id']); ?>" <?php echo e((isset($filters['countryId']) && $filters['countryId']==$country['id']) ? 'selected':''); ?>>
                                    <?php echo e($country['name']); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="event-date col-sm-6 col-md-3">
                        <label>Event Date</label>
                        <select name="date" class="selectpicker dropdown">
                            <option value="">Select Date</option>
                            <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php echo e((isset($filters['date']) && $filters['date']==$key) ? 'selected' : ''); ?>>
                                    <?php echo e($date); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-sm-6 col-md-2">
                        <input type="submit" value="Search">
                        <button type="button" class="button-reset" id="reset-filters">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <section class="section-search-content">
        <div class="container">
            <div class="row">
                <div id="secondary" class="col-md-4 col-lg-3">
                    <div class="search-filter">
                        <div class="search-event-title">
                            <h2><span>Event</span> COLDPLAY CONCERT</h2>
                        </div>
                        <div class="search-filter-delivery">
                            <h3>Delivery</h3>
                            <?php
                                $deliveryOptions = ['All','Electronic','Instant'];
                            ?>

                            <?php $__currentLoopData = $deliveryOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="checkbox">
                                    <input id="delivery<?php echo e($index); ?>" class="styled" type="checkbox" name="delivery[]"
                                           value="<?php echo e($option); ?>"
                                           <?php echo e((isset($filters['delivery']) && in_array($option, (array)$filters['delivery'])) || $option=='All' ? 'checked' : ''); ?>

                                           onchange="this.form.submit()">
                                    <label for="delivery<?php echo e($index); ?>"><?php echo e($option); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="search-filter-seat-features">
                            <h3>Seat Features</h3>
                            <?php
                                $features = ['All','Aisle','Ex-Obstucted View','Parking Pass Included','Wheelchair Accessible'];
                            ?>
                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="checkbox">
                                    <input id="feature<?php echo e($index); ?>" class="styled" type="checkbox" name="features[]"
                                           value="<?php echo e($feature); ?>"
                                           <?php echo e((isset($filters['features']) && in_array($feature, (array)$filters['features'])) || $feature=='All' ? 'checked' : ''); ?>

                                           onchange="this.form.submit()">
                                    <label for="feature<?php echo e($index); ?>"><?php echo e($feature); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="search-filter-price">
                            <h3>Price</h3>
                            <input id="price-range" type="text" class="span2" value="" data-slider-min="10" data-slider-max="200" data-slider-step="5" data-slider-value="[50,150]"/>
                            <input type="hidden" name="price_range" id="price_range_hidden" value="<?php echo e($filters['price_range'] ?? ''); ?>">
                        </div>
                    </div>
                </div>

                <div id="primary" class="col-md-8 col-lg-9">
                    <?php if(count($events) == 0): ?>
                        <p>No events found for your filters.</p>
                    <?php endif; ?>
                    <div class="search-result-header">
                        <div class="row">
                            <div class="col-sm-7">
                                <h2>Coldplay Concert at San Francisco</h2>
                                <span>Showing <?php echo e($events->total()); ?> results</span>

                            </div>
                            <div class="col-sm-5">
                                <label>Sort By</label>
                                <select name="sort" class="selectpicker dropdown" onchange="$('#ticket-filter-form').submit()">
                                    <option value="price_asc" <?php echo e((request('sort')=='price_asc') ? 'selected' : ''); ?>>Price: Low-High</option>
                                    <option value="price_desc" <?php echo e((request('sort')=='price_desc') ? 'selected' : ''); ?>>Price: High-Low</option>
                                </select>
                            </div>
                        </div>
                    </div>

                        <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <div class="search-result-item">
                                <div class="row">
                                    <div class="search-result-item-info col-sm-9">
                                        <h3>
                                            <?php if(isset($event['homeTeam'], $event['awayTeam'])): ?>
                                                <?php echo e($event['homeTeam']['name']); ?> vs <?php echo e($event['awayTeam']['name']); ?>

                                            <?php elseif(isset($event['participants'])): ?>
                                                <?php echo e($event['participants']['name']); ?>

                                            <?php else: ?>
                                                <?php echo e($event['name'] ?? 'Event'); ?>

                                            <?php endif; ?>
                                        </h3>
                                        <ul class="row">
                                            <li class="col-sm-3 col-lg-4">
                                                <span>Venue</span> <?php echo e($event['venue']['name'] ?? ''); ?>

                                            </li>
                                            <li class="col-sm-3 col-lg-2">
                                                <span>Country</span> <?php echo e($event['country']['name'] ?? ''); ?>

                                            </li>
                                            <li class="col-sm-4 col-lg-3">
                                                <span>Date</span>
                                                <?php echo e(isset($event['dateOfEvent']) ? \Carbon\Carbon::createFromFormat('d/m/Y', $event['dateOfEvent'])->format('F jS, Y') : ''); ?>

                                            </li>
                                            <li class="col-sm-2">
                                                <span>Time</span> <?php echo e($event['timeOfEvent'] ?? ''); ?>

                                            </li>
                                        </ul>
                                    </div>
                                    <div class="search-result-item-price col-sm-3">
                                        <span>Price From</span>
                                        <strong>$<?php echo e($event['minTicketPrice']['price'] ?? 'N/A'); ?></strong>
                                        <a href="<?php echo e(route('front.ticket.show',$event['id'])); ?>" class="btn btn-success btn-sm">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p>No events found for your filters.</p>
                        <?php endif; ?>




                    <div class="search-result-footer">
                        <?php echo e($events->withQueryString()->links()); ?>


                        
















                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function(){
            $('.styled[type="checkbox"]').change(function() {
                $('#ticket-filter-form').submit();
            });

            if($("#price-range").length) {
                $("#price-range").slider({
                    range: true,
                    min: 10,
                    max: 200,
                    step: 5,
                    values: [50,150],
                    slide: function(event, ui) {
                        $("#price_range_hidden").val(ui.values[0] + '-' + ui.values[1]);
                    },
                    change: function(event, ui) {
                        $('#ticket-filter-form').submit();
                    }
                });

                    <?php if(!empty($filters['price_range'])): ?>
                var vals = "<?php echo e($filters['price_range']); ?>".split('-');
                $("#price-range").slider("values", [parseInt(vals[0]), parseInt(vals[1])]);
                <?php endif; ?>
            }

            // Reset Filters
            $('#reset-filters').click(function(){
                $('#ticket-filter-form')[0].reset();
                $("#price_range_hidden").val('');
                $("#price-range").slider("values", [50,150]);

                $('#ticket-filter-form').find('input, select').each(function(){
                    if(!$(this).val()) {
                        $(this).prop('disabled', true);
                    }
                });
                $('#ticket-filter-form').submit();
                $('#ticket-filter-form').find('input, select').prop('disabled', false);
                window.location.href = "<?php echo e(route('front.ticket')); ?>";
            });

        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('front.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sport/public_html/back/sport/resources/views/front/ticket.blade.php ENDPATH**/ ?>