<?php

use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Front\SeitController;
use App\Http\Controllers\Front\CommentController;
use App\Http\Controllers\Auth\RegisterController;
use Illuminate\Support\Facades\Route;


// index
Route::get('/', [SeitController::class, 'index'])->name('index');
Route::get('/ticket', [SeitController::class, 'ticket'])->name('ticket');
Route::get('/ticket/{id}', [SeitController::class, 'ticket_show'])->name('ticket.show');

// about us
Route::get('/about-us/{slug?}', [HomeController::class, 'about'])->name('about.us');
// about us
Route::get('/faqs', [HomeController::class, 'faq'])->name('faq');


// contact us
Route::get('/contact-us', [HomeController::class, 'contact'])->name('contact.us');
Route::post('/contact-us/post', [HomeController::class, 'contact_post'])->name('contact.us.post');

//blogs
Route::get('/blogs', [HomeController::class, 'blog_list'])->name('blog.list');
Route::get('/blogs/{slug}', [HomeController::class, 'blog_show'])->name('blog.show');
//send comment
Route::middleware('auth')->group(function () {
    Route::post('/blogs/{blog}/comment',[HomeController::class, 'send_comment'])->name('send.comment');
});

//R&D
//products
Route::get('/products/{cat_slug?}', [HomeController::class, 'product_list'])->name('product.list');
Route::get('/product/{slug}', [HomeController::class, 'product_show'])->name('product.show');

Route::get('/encyclopedia', [HomeController::class, 'encyclopedia_list'])->name('encyclopedia.list');
Route::get('/encyclopedia/{slug}', [HomeController::class, 'encyclopedia_show'])->name('encyclopedia.show');


Route::post('/newsletter', [HomeController::class, 'newsletter'])->name('newsletter');
Route::post('/comment', [HomeController::class, 'newsletter'])->name('comment');
//services

Route::post('register', [RegisterController::class, 'register'])->name('register');



