<?php

use App\Http\Controllers\Admin\Blog\BlogCategoryController;
use App\Http\Controllers\Admin\Blog\TagController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Access\PermissionCatController;
use App\Http\Controllers\Admin\Access\PermissionController;
use App\Http\Controllers\Admin\Access\RoleController;

use App\Http\Controllers\Admin\Form\AllFormController;

use App\Http\Controllers\Admin\Setting\MediaController;
use App\Http\Controllers\Admin\Setting\LangSetController;
use App\Http\Controllers\Admin\Setting\ProfileController;
use App\Http\Controllers\Admin\Setting\SliderController;
use App\Http\Controllers\Admin\Setting\MetaController;
use App\Http\Controllers\Admin\Setting\AboutController;
use App\Http\Controllers\Admin\Setting\SettingController;
use App\Http\Controllers\Admin\Setting\ContactController;
use App\Http\Controllers\Admin\Setting\UploadController;
use App\Http\Controllers\Admin\Setting\SiteWordController;
use App\Http\Controllers\Admin\Setting\UploadSitemapController;
use App\Http\Controllers\Admin\Setting\UploadRobotController;
use App\Http\Controllers\Admin\Setting\RedirectController;
use App\Http\Controllers\Admin\Setting\PageHeaderController;

use App\Http\Controllers\Admin\User\UserController;

use App\Http\Controllers\Admin\Blog\BlogController;

use App\Http\Controllers\Admin\Other\TeamController;
use App\Http\Controllers\Admin\Other\ServiceController;
use App\Http\Controllers\Admin\Other\FaqController;
use App\Http\Controllers\Admin\Other\CategoryFaqController;
use App\Http\Controllers\Admin\Other\CertificateController;
use App\Http\Controllers\Admin\Other\PartnerController;
use App\Http\Controllers\Admin\Other\BannerController;
use App\Http\Controllers\Admin\Other\ResearchProjectController;


use App\Http\Controllers\Admin\Product\CategoryController;
use App\Http\Controllers\Admin\Product\ProductController;
use App\Http\Controllers\Admin\Product\ProductEncyclopediaController;

use App\Http\Controllers\Admin\Gallery\GalleryController;


Route::get('translations', [\App\Http\Controllers\Admin\Setting\TranslationController::class, 'index'])
    ->name('translations.index');
Route::post('translations/extract', [\App\Http\Controllers\Admin\Setting\TranslationController::class, 'extractAndTranslate'])
    ->name('translations.extract');


Route::post('translations/process-ajax', [\App\Http\Controllers\Admin\Setting\TranslationController::class, 'processAjax'])
    ->name('translations.process-ajax');

Route::post('translations/store', [\App\Http\Controllers\Admin\Setting\TranslationController::class, 'store'])
    ->name('translations.store');
Route::put('translations/{id}', [\App\Http\Controllers\Admin\Setting\TranslationController::class, 'update'])
    ->name('translations.update');

//Access
Route::resource('permission-cat', PermissionCatController::class);
Route::resource('permission', PermissionController::class);
Route::resource('role', RoleController::class);

//Setting
Route::get('profile', [ProfileController::class,'show'])->name('profile.show');
Route::patch('profile/{id}/update', [ProfileController::class,'update'])->name('profile.update');

Route::resource('lang-set', LangSetController::class);
Route::get('lang-set-status/{id}/{type}/{status}', [LangSetController::class,'status'])->name('lang-set.status');

Route::resource('meta', MetaController::class);
Route::get('meta-status/{id}/{type}/{status}', [MetaController::class,'status'])->name('meta.status');

Route::resource('about', AboutController::class);

Route::resource('setting', SettingController::class);
Route::get('pic-delete/{id}', [SettingController::class,'delete_pic'])->name('pic.delete');
Route::get('delete-photo/', [SettingController::class,'delete_photo'])->name('setting.delete.photo');

Route::resource('page-header', PageHeaderController::class);

Route::resource('contact', ContactController::class);

Route::resource('upload', UploadController::class);
Route::resource('upload-robots', UploadRobotController::class);
Route::resource('upload-sitemaps', UploadSitemapController::class);

Route::resource('site-word', SiteWordController::class);

Route::resource('slider', SliderController::class);
Route::get('slider-status/{id}/{type}/{status}', [SliderController::class,'status'])->name('slider.status');

//User
Route::resource('user', UserController::class);
Route::get('user-status/{id}/{type}/{status}', [UserController::class,'status'])->name('user.status');
Route::get('user/permission/{id}/edit', [UserController::class,'permission_edit'])->name('user.edit.permission');
Route::post('user/permission/{id}/update', [UserController::class,'permission_update'])->name('user.update.permission');
Route::get('user/fast/{id}/login', [UserController::class,'fast_login'])->name('user.fast.login');
Route::get('user/fast/login', [UserController::class,'back_login'])->name('user.back.login');

//Form
Route::get('form/contact/list', [AllFormController::class,'contact'])->name('form.contact.index');

//Blog
Route::resource('blog', BlogController::class);
Route::post('blog-sort/{id}', [BlogController::class,'sort'])->name('blog.sort');

//Blog Category
Route::resource('blog-category', BlogCategoryController::class);
Route::post('blog-category-sort/{id}', [BlogCategoryController::class,'sort'])->name('blog-category.sort');

//Product
Route::resource('product-category', CategoryController::class);
Route::post('product-category-sort/{id}', [CategoryController::class,'sort'])->name('product-category.sort');

Route::resource('product', ProductController::class);
Route::get('product/attr/{id}/list', [ProductController::class,'attr_list'])->name('product.attr.list');
Route::post('product/attr/{id}/store', [ProductController::class,'attr_store'])->name('product.attr.store');
Route::delete('product/attr/{id}/destroy', [ProductController::class,'attr_destroy'])->name('product.attr.destroy');
Route::post('product/attr/{id}/sort', [ProductController::class,'attr_sort'])->name('product.attr.sort');

Route::resource('product-encyclopedia', ProductEncyclopediaController::class);
Route::get('product-encyclopedia/{id}/status/{type}', [ProductEncyclopediaController::class,'status'])->name('product-encyclopedia.status');
Route::post('product-encyclopedia/{id}/sort', [ProductEncyclopediaController::class,'sort'])->name('product-encyclopedia.sort');
Route::get('product-encyclopedia/attr/{id}/list', [ProductEncyclopediaController::class,'attr_list'])->name('product-encyclopedia.attr.list');
Route::post('product-encyclopedia/attr/{id}/store', [ProductEncyclopediaController::class,'attr_store'])->name('product-encyclopedia.attr.store');
Route::delete('product-encyclopedia/attr/{id}/destroy', [ProductEncyclopediaController::class,'attr_destroy'])->name('product-encyclopedia.attr.destroy');
Route::post('product-encyclopedia/attr/{id}/sort', [ProductEncyclopediaController::class,'attr_sort'])->name('product-encyclopedia.attr.sort');
//other
Route::resource('service', ServiceController::class);
Route::post('service-sort/{id}', [ServiceController::class,'sort'])->name('service.sort');

Route::resource('team', TeamController::class);
Route::post('team-sort/{id}', [TeamController::class,'sort'])->name('team.sort');

Route::resource('project', ResearchProjectController::class);
Route::get('project-status/{id}/{type}/{status}', [ResearchProjectController::class,'status'])->name('project.status');
//Certificate
Route::resource('certificate', CertificateController::class);
//Partner
Route::resource('partner', PartnerController::class);
//Banner
Route::resource('banner', BannerController::class);

//faq
Route::resource('faq', FaqController::class);
Route::post('faq-sort/{id}', [FaqController::class,'sort'])->name('faq.sort');
Route::get('faq-status/{id}/{type}', [FaqController::class,'status'])->name('faq.status');
Route::post('faq/get-children', [FaqController::class, 'getChildren'])->name('faq.get.children');

Route::resource('faq-category', CategoryFaqController::class);
Route::post('faq-category-sort/{id}', [CategoryFaqController::class,'sort'])->name('faq.category.sort');
Route::get('faq-category-status/{id}/{type}', [CategoryFaqController::class,'status'])->name('faq.category.status');


//Gallery
Route::resource('gallery', GalleryController::class);
Route::get('gallery-status/{id}/{type}/{status}', [GalleryController::class,'status'])->name('gallery.status');
Route::post('gallery-sort/{id}', [GalleryController::class,'sort'])->name('gallery.sort');
Route::get('gallery-delete/{id}', [GalleryController::class,'delete'])->name('gallery.delete');

Route::get('media', [MediaController::class, 'index'])->name('media.index');
Route::post('media/{id}', [MediaController::class, 'edit_alt'])->name('media.edit_alt');

//410
Route::resource('redirect', RedirectController::class);
Route::get('redirect-status/{id}/{status}', [RedirectController::class,'status'])->name('redirect.status');

//Tag
Route::resource('tags', TagController::class);
Route::post('tag-sort/{id}', [TagController::class,'sort'])->name('tags.sort');




