@extends('front.layouts.front')
@section('body')

    <section class="section-page-header">
        <div class="container">
            <h1 class="entry-title">Review Order</h1>
        </div>
    </section>

    <section class="section-page-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="alert alert-info" role="alert">
                        <p><i class="fa fa-check" aria-hidden="true"></i> Ticket price has been confirmed. Check your order review below and click Checkout to continue.</p>
                    </div>
                </div>

                {{-- Event Info --}}
                <div id="primary" class="col-md-6">
                    <div class="section-order-details-event-info">
                        <div class="venue-details">
                            <h3>Venue & Event Information</h3>
                            <div class="venue-details-info">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="section-order-review-event-img">
                                            <a href="{{ $event['data']['venue']['mapUrl'] }}" data-featherlight="image">
                                                <img class="event-img" src="{{ $event['data']['venue']['mapUrl'] }}" alt="Event Image">
                                            </a>
                                            <span>
                                            <i class="fa fa-search" aria-hidden="true"></i>
                                            Click to enlarge
                                        </span>
                                        </div>
                                    </div>
                                    <div class="col-sm-8">
                                        <div class="section-order-review-event">
                                            <span class="event-caption">{{ $event['data']['tournament']['name'] ?? '' }}</span>
                                            <h2 class="event-title">
                                                {{ $event['data']['homeTeam']['name'] ?? ($event['data']['name'] ?? '') }}
                                                @if(!empty($event['data']['awayTeam']['name']))
                                                    VS {{ $event['data']['awayTeam']['name'] }}
                                                @endif
                                            </h2>
                                            <p>{{ $event['data']['venue']['name'] ?? '' }} - {{ $event['data']['city']['name'] ?? '' }}</p>
                                            <p>
                                                {{ \Carbon\Carbon::createFromFormat('d/m/Y', $event['data']['dateOfEvent'])->format('l, d F Y') ?? '' }}
                                                <span>{{ $event['data']['timeOfEvent'] ?? '' }}</span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Seat/Ticket Details --}}
                        <div class="seat-details">
                            <h3>Seats Order Information</h3>
                            <div class="seat-details-info">
                                <table class="table seat-row">
                                    <thead>
                                    <tr>
                                        <th>Section</th>
                                        <th>Row</th>
                                        <th>Seats</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($tickets['data'] ?? [] as $ticket)
                                        <tr>
                                            <td>{{ $ticket['section'] ?? 'N/A' }}</td>
                                            <td>{{ $ticket['row'] ?? 'N/A' }}</td>
                                            <td>{{ $ticket['seats'] ?? 'N/A' }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                                <table class="table number-tickets">
                                    <thead>
                                    <tr>
                                        <th>Delivery</th>
                                        <th>Number of Tickets</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($tickets['data'] ?? [] as $ticket)
                                        <tr>
                                            <td>{{ $ticket['delivery'] ?? 'Instant Download' }}</td>
                                            <td>1</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Pricing & Checkout --}}
                <div id="secondary" class="col-md-6">
                    <div class="section-order-review-pricing">
                        <div class="pricing-coupon">
                            <h3>Pricing & Coupon</h3>
                            <div class="coupon">
                                <div class="row">
                                    <div class="col-sm-12 col-lg-4">
                                        <div class="coupon-title">
                                            <span>Enter Coupon Code Here</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-lg-8">
                                        <div class="coupon-form">
                                            <input type="text" placeholder="Code">
                                            <input type="submit" value="Update">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- Price Calculation --}}
                            @php
                                $ticketPrice = $tickets['data'][0]['price'] ?? 0;
                                $totalPrice = $ticketPrice * count($tickets['data']);
                            @endphp

                            <div class="pricing">
                                <table class="table pricing-review">
                                    <tbody>
                                    <tr>
                                        <td>Ticket price ({{ count($tickets['data'] ?? []) }} x ${{ $ticketPrice }})</td>
                                        <td>${{ $totalPrice }}</td>
                                    </tr>
                                    <tr>
                                        <td>Total Fee</td>
                                        <td>$24.10</td>
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td>Total Price</td>
                                        <td class="total-price">USD ${{ $totalPrice + 24.10 }}</td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <div class="delivery-method">
                            <h3>Delivery</h3>
                            <div class="delivery-info">
                                <span>Instant Download</span>
                                <p>Available to download within few minutes</p>
                            </div>
                        </div>

                        <div class="section-order-details-event-action">
                            <div class="row">
                                <div class="col-sm-offset-5 col-sm-7 col-lg-offset-6 col-lg-6">
                                    <a class="primary-link" href="{{ $event['data']['eventUrl'] ?? '#' }}">Proceed Checkout</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

@endsection
