@extends('front.layouts.front')
@section('body')
    <section class="section-refine-search">
        <div class="container">
            <div class="row">
                <form method="GET" action="{{ route('front.ticket') }}" id="ticket-filter-form">
                    <div class="keyword col-sm-6 col-md-4">
                        <label>Search Keyword</label>
                        <input type="text" name="keyword" class="form-control hasclear" placeholder="Search"
                        value="{{ $filters['keyword'] ?? '' }}">
                        <span class="clearer"><img src="{{asset('assets/front/images/clear.png') }}" alt="image"></span>
                    </div>
                    <div class="location col-sm-6 col-md-3">
                        <label>Location</label>
                        <select name="country_id" class="selectpicker dropdown">
                            <option value="">Select Location</option>
                            @foreach($countries as $country)
                                <option value="{{ $country['id'] }}" {{ (isset($filters['countryId']) && $filters['countryId']==$country['id']) ? 'selected':'' }}>
                                    {{ $country['name'] }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="event-date col-sm-6 col-md-3">
                        <label>Event Date</label>
                        <select name="date" class="selectpicker dropdown">
                            <option value="">Select Date</option>
                            @foreach($dates as $key => $date)
                                <option value="{{ $key }}" {{ (isset($filters['date']) && $filters['date']==$key) ? 'selected' : '' }}>
                                    {{ $date }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-6 col-md-2">
                        <input type="submit" value="Search">
                        <button type="button" class="button-reset" id="reset-filters">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <section class="section-search-content">
        <div class="container">
            <div class="row">
                <div id="secondary" class="col-md-4 col-lg-3">
                    <div class="search-filter">
                        <div class="search-event-title">
                            <h2><span>Event</span> COLDPLAY CONCERT</h2>
                        </div>
                        <div class="search-filter-delivery">
                            <h3>Delivery</h3>
                            @php
                                $deliveryOptions = ['All','Electronic','Instant'];
                            @endphp

                            @foreach($deliveryOptions as $index => $option)
                                <div class="checkbox">
                                    <input id="delivery{{ $index }}" class="styled" type="checkbox" name="delivery[]"
                                           value="{{ $option }}"
                                           {{ (isset($filters['delivery']) && in_array($option, (array)$filters['delivery'])) || $option=='All' ? 'checked' : '' }}
                                           onchange="this.form.submit()">
                                    <label for="delivery{{ $index }}">{{ $option }}</label>
                                </div>
                            @endforeach
                        </div>
                        <div class="search-filter-seat-features">
                            <h3>Seat Features</h3>
                            @php
                                $features = ['All','Aisle','Ex-Obstucted View','Parking Pass Included','Wheelchair Accessible'];
                            @endphp
                            @foreach($features as $index => $feature)
                                <div class="checkbox">
                                    <input id="feature{{ $index }}" class="styled" type="checkbox" name="features[]"
                                           value="{{ $feature }}"
                                           {{ (isset($filters['features']) && in_array($feature, (array)$filters['features'])) || $feature=='All' ? 'checked' : '' }}
                                           onchange="this.form.submit()">
                                    <label for="feature{{ $index }}">{{ $feature }}</label>
                                </div>
                            @endforeach
                        </div>
                        <div class="search-filter-price">
                            <h3>Price</h3>
                            <input id="price-range" type="text" class="span2" value="" data-slider-min="10" data-slider-max="200" data-slider-step="5" data-slider-value="[50,150]"/>
                            <input type="hidden" name="price_range" id="price_range_hidden" value="{{ $filters['price_range'] ?? '' }}">
                        </div>
                    </div>
                </div>

                <div id="primary" class="col-md-8 col-lg-9">
                    @if(count($events) == 0)
                        <p>No events found for your filters.</p>
                    @endif
                    <div class="search-result-header">
                        <div class="row">
                            <div class="col-sm-7">
                                <h2>Coldplay Concert at San Francisco</h2>
                                <span>Showing {{ $events->total() }} results</span>

                            </div>
                            <div class="col-sm-5">
                                <label>Sort By</label>
                                <select name="sort" class="selectpicker dropdown" onchange="$('#ticket-filter-form').submit()">
                                    <option value="price_asc" {{ (request('sort')=='price_asc') ? 'selected' : '' }}>Price: Low-High</option>
                                    <option value="price_desc" {{ (request('sort')=='price_desc') ? 'selected' : '' }}>Price: High-Low</option>
                                </select>
                            </div>
                        </div>
                    </div>

                        @forelse($events as $event)

                            <div class="search-result-item">
                                <div class="row">
                                    <div class="search-result-item-info col-sm-9">
                                        <h3>
                                            @if(isset($event['homeTeam'], $event['awayTeam']))
                                                {{ $event['homeTeam']['name'] }} vs {{ $event['awayTeam']['name'] }}
                                            @elseif(isset($event['participants']))
                                                {{ $event['participants']['name'] }}
                                            @else
                                                {{ $event['name'] ?? 'Event' }}
                                            @endif
                                        </h3>
                                        <ul class="row">
                                            <li class="col-sm-3 col-lg-4">
                                                <span>Venue</span> {{ $event['venue']['name'] ?? '' }}
                                            </li>
                                            <li class="col-sm-3 col-lg-2">
                                                <span>Country</span> {{ $event['country']['name'] ?? '' }}
                                            </li>
                                            <li class="col-sm-4 col-lg-3">
                                                <span>Date</span>
                                                {{ isset($event['dateOfEvent']) ? \Carbon\Carbon::createFromFormat('d/m/Y', $event['dateOfEvent'])->format('F jS, Y') : '' }}
                                            </li>
                                            <li class="col-sm-2">
                                                <span>Time</span> {{ $event['timeOfEvent'] ?? '' }}
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="search-result-item-price col-sm-3">
                                        <span>Price From</span>
                                        <strong>${{ $event['minTicketPrice']['price'] ?? 'N/A' }}</strong>
                                        <a href="{{route('front.ticket.show',$event['id'])}}" class="btn btn-success btn-sm">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <p>No events found for your filters.</p>
                        @endforelse




                    <div class="search-result-footer">
                        {{ $events->withQueryString()->links() }}

                        {{--                        <ul class="pagination">--}}
{{--                            <li>--}}
{{--                                <a href="#" aria-label="Previous">--}}
{{--                                    <span aria-hidden="true"><i class="fa fa-long-arrow-left" aria-hidden="true"></i> Previous</span>--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                            <li><a href="#">1</a></li>--}}
{{--                            <li><a href="#">2</a></li>--}}
{{--                            <li class="active"><a href="#">3</a></li>--}}
{{--                            <li><a href="#">4</a></li>--}}
{{--                            <li><a href="#">5</a></li>--}}
{{--                            <li>--}}
{{--                                <a href="#" aria-label="Next">--}}
{{--                                    <span aria-hidden="true">Next <i class="fa fa-long-arrow-right" aria-hidden="true"></i></span>--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                        </ul>--}}
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('scripts')
    <script>
        $(document).ready(function(){
            $('.styled[type="checkbox"]').change(function() {
                $('#ticket-filter-form').submit();
            });

            if($("#price-range").length) {
                $("#price-range").slider({
                    range: true,
                    min: 10,
                    max: 200,
                    step: 5,
                    values: [50,150],
                    slide: function(event, ui) {
                        $("#price_range_hidden").val(ui.values[0] + '-' + ui.values[1]);
                    },
                    change: function(event, ui) {
                        $('#ticket-filter-form').submit();
                    }
                });

                    @if(!empty($filters['price_range']))
                var vals = "{{ $filters['price_range'] }}".split('-');
                $("#price-range").slider("values", [parseInt(vals[0]), parseInt(vals[1])]);
                @endif
            }

            // Reset Filters
            $('#reset-filters').click(function(){
                $('#ticket-filter-form')[0].reset();
                $("#price_range_hidden").val('');
                $("#price-range").slider("values", [50,150]);

                $('#ticket-filter-form').find('input, select').each(function(){
                    if(!$(this).val()) {
                        $(this).prop('disabled', true);
                    }
                });
                $('#ticket-filter-form').submit();
                $('#ticket-filter-form').find('input, select').prop('disabled', false);
                window.location.href = "{{ route('front.ticket') }}";
            });

        });

    </script>
@endpush
