@if($teams)
    <section id="sapintaTeamSection" class="sapintaTeamSection bg-orange-50 py-16 px-6 scroll-marginTop1">
        <div class="sapintaTeamWrapper max-w-6xl mx-auto text-center">

            <!-- Main Title -->
            <h2 class="sapintaTeamTitle text-xl md:text-2xl lg:text-3xl font-bold text-sky-900 mb-4">
                {{read_lang($item,'text3')}}
            </h2>

            <!-- Introduction Text -->
            <div class="sapintaTeamIntro max-w-3xl mx-auto text-sky-700 text-lg mb-12">
                {!! read_lang($item,'text1') !!}
            </div>

        </div>
        <div class="teamFilter">
            <!-- Filter Buttons -->
            <div class="TeamFilterBar flex flex-wrap gap-3 px-6 py-4 justify-center rounded-xl">
                <button class="TeamFilterBtn flex items-center gap-2  px-4 py-2 rounded-lg  transition text-sm  shadow-sm selectedBarItem"  data-role="all">All Team</button>
                @foreach($roles as $role)
                    <button class="TeamFilterBtn flex items-center gap-2  px-4 py-2 rounded-lg  transition text-sm  shadow-sm unelectedBarItem" data-role="{{ $role }}">
                        {{ $role }}</button>

                @endforeach
            </div>

            <div class="max-w-6xl mx-auto text-center mt-8">

                <!-- Team Member Cards -->
                <div class="sapintaTeamCards grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-8 max-w-6xl mx-auto mb-12">
                    @foreach($teams as $member)

                        <div class="sapintaTeamCard bg-white  transition-all duration-300 ease-in-out  border rounded-xl shadow-lg p-6 flex flex-col items-center" data-role="{{ $member->text }}">
                            @if($item->photo && is_file($item->photo->path))
                                <img src="{{url($member->photo->path)}}" alt="Dr. Smith" class="sapintaTeamImg  scale1 w-32 h-32 rounded-full mb-4 object-cover">
                            @else
                                ثبت نشده
                            @endif
                            <h3 class="sapintaTeamName  line-clamp-1 text-xl font-semibold text-sky-900 mb-1"> {{ $member->name }}</h3>
                            <p class="sapintaTeamRole line-clamp-1 line-clamp-1 font-medium mb-2">  {{ $member->text }} </p>
                            <div class="sapintaTeamDesc  line-clamp-4 text-justify text-left text-sm">
                                {!! $member->dis !!}
                            </div>
                        </div>

                    @endforeach

                </div>

                <!-- Final Slogan -->
                <p class="sapintaTeamSlogan text-sky-800 italic font-semibold mb-8 max-w-xl mx-auto">
                    "{{read_lang_word('science')}}"
                </p>

                <!-- Call to Action Button -->
                <a href="#" class="sapintaTeamCTA inline-block bg-sky-900 text-white px-8 py-3 rounded-full font-semibold hover:bg-sky-700 transition-colors">
                    {{read_lang_word('talk-coach')}}
                </a>
            </div>
        </div>
    </section>
@endif
