<!-- Hero Section -->
<section class="heroSection relative w-full h-screen overflow-hidden bg-gray-900 text-white -mt-20">
    <!-- Background image or video -->
    <img src="{{ $pic }}" alt="Hero background" class=" inset-0 w-full h-full object-cover opacity-40 z-0">
    <!-- Overlay content -->
    <div class="absolute inset-0  z-10 flex flex-col justify-center items-center h-full text-center px-6">
        <h1 class="text-3xl md:text-4xl font-extrabold mb-4"> {{ $title }}</h1>
        <p class="text-xl md:text-2xl my-6 max-w-2xl text-gray-100 font-bold">{{ $subtitle ?? ''  }}</p>
        @if($page == 'research')
            <p id="animated-quote" class="text-lg md:text-xl mb-8 max-w-2xl text-gray-100"></p>
        @elseif($page == 'blog' || 'faq' )
            <p class="text-lg md:text-xl mb-8 max-w-6xl text-gray-100"> {{ $text ?? '' }}</p>
        @else
            <p class="text-lg md:text-xl mb-8 max-w-2xl text-gray-100"> {{ $text ?? '' }}</p>
        @endif
        <!-- CTA buttons for About Page -->
        <div class="flex flex-col sm:flex-row gap-4">
            <a href="{{ $url_button ?? ''  }}" class="heroSectionBtn primaryBtn HoverPrimaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                {{ $button }}
            </a>
            @if(isset($button2))
            <a href=" {{ $url_button2 ?? ''  }}" class="heroSectionBtn HoverPrimaryBtn bg-white bg-opacity-10 border border-white border-opacity-10 shadow-inner px-6 py-3 rounded-lg font-semibold transition">
                {{ $button2 ?? ''  }}
            </a>
            @endif
        </div>
    </div>
</section>
