@foreach($courses as $course)
    <div class="course-card bg-white rounded-xl shadow-md overflow-hidden transition group"
         data-subject="mathematics"
         data-format="semi-private group"
         data-entry="secondary1"
         data-contest="exam-prep core-concept">

        <!-- Image Section with Category Badges -->
        <div class="course-image-wrapper relative">
            <img src="{{$course->photo && is_file($course->photo->path)?url($course->photo->path):url('assets/front/img/home1/blog-1.jpg')}}" alt="Course Image"
                 class="course-image w-full h-48 object-cover transition-transform duration-500 ease-in-out scale1">

            <!-- Left Badge -->
            <div class="badge badge-left absolute top-0 left-0 m-2 ">
                      <span class="badge-math text-xs px-2 py-1 rounded-full flex items-center gap-1 bg-purple-100 text-purple-600">
                          {{$course->excerpt}}
                      </span>
            </div>

        </div>

        <!-- Course Content -->
        <div class="course-content p-4 text-sm">
            <!-- Title -->
            <h3 class="course-title text-lg font-bold mb-2 line-clamp-2">
                {{$course->title}}
            </h3>

            <!-- Description -->
            <p class="course-desc text-sm text-gray-600 dark:text-gray-300 mb-4 text-justify line-clamp-7">
                {{ Str::limit(strip_tags($course->description), 250) }}
            </p>


            <!-- Meta Info -->
            <div class="grid grid-cols-2 gap-3 text-xs text-gray-600 dark:text-gray-300 mb-4">
                <div class="flex items-center gap-2">
                    <i class="fa-solid fa-clock text-blue-600 transition-all duration-300 ease-in-out"></i>
                    {{$course->duration_weeks}}
                </div>
                <div class="flex items-center gap-2">
                    <i class="fa-solid fa-video text-purple-600 transition-all duration-300 ease-in-out"></i>
                    @if($course->access_type == 'All')
                        {{read_lang_word('all-access-type')}}
                    @else
                        {{ ucfirst($course->access_type) }}
                    @endif
                </div>
                <div class="flex items-center gap-2">
                    <i class="fa-solid fa-signal text-green-600 transition-all duration-300 ease-in-out"></i>
                    {{$course->level}}
                </div>
                <div class="flex items-center gap-2">
                    <i class="fa-solid fa-calendar-days text-yellow-400 transition-all duration-300 ease-in-out"></i>
                    {{ $course->created_at->toFormattedDateString() }}
                </div>
                <div class="flex items-center gap-2 col-span-2">
                    <i class="fa-solid fa-calendar-week text-indigo-600"></i>
                    Sessions: {{ $course->schedule_string }}
                </div>
            </div>

            <!-- Call to Action Button -->
            <a href="{{route('front.course.detail',$course->slug)}}" class="course-btn primaryBtn HoverPrimaryBtn text-white px-6 py-2 rounded-lg font-semibold transition">View Course</a>
        </div>
    </div>
@endforeach
