<section class="approved-section bg-gray-50 py-12 px-6 ">
    <div class="max-w-6xl mx-auto text-center">

        <!-- Headline Section -->
        <h2 class="text-xl md:text-2xl lg:text-3xl font-extrabold text-sky-900 mb-4 headline">
            {{read_lang_word('approved')}}
        </h2>

        <!-- Subheadline Section -->
        <p class="text-gray-700 max-w-2xl mx-auto mb-10 subheadline">
            {{read_lang_word('trusted-quality')}}
        </p>

        <!-- Swiper Slider Container -->
        <div class="swiper approvedSectionSwiper w-full mx-auto logo-slider relative">

            <!-- Swiper Wrapper: Slides Container -->
            <div class="swiper-wrapper h-full logo-slider-wrapper">
                @foreach($certificate as $item)
                    <div class="swiper-slide p-5 logo-slide">
                        <div class="w-full h-32 logo-slide-content">
                            @if($item->photo && is_file($item->photo->path))
                                <img src="{{url($item->photo->path)}}" alt=" {{$item->title}}" class="w-full h-full mx-auto mb-4 object-cover logo-image" />

                            @else
                                <img src="{{asset('assets/sapienta/imges/logo/sapieenta logo design-02.svg') }}" alt="Logo 2" class="w-full h-full mx-auto mb-4 object-cover logo-image" />

                            @endif
                        </div>
                    </div>

            @endforeach
            <!-- Each Slide -->

            </div>

            <!-- Navigation Arrows -->
            <div class="swiper-button-next primary-light-hover scale1 navigation-button bg-opacity-70 rounded-full w-5 h-5 p-5 text-sm"></div>
            <div class="swiper-button-prev primary-light-hover scale1 navigation-button bg-opacity-70 rounded-full w-5 h-5 p-5 text-sm"></div>
        </div>

        <!-- Testimonials Section -->
        <div class="max-w-4xl mx-auto space-y-4 mt-4 testimonials">
            <blockquote class="text-gray-800 italic  testimonial-quote">
                “{{read_lang_word('modern-education')}}”
            </blockquote>
            <p class="text-left font-semibold  testimonial-author">— {{read_lang_word('education-times')}}</p>
        </div>

        <!-- Call to Action Button -->
        <div class="mt-12 cta-button-container">
            <a href="#" class="primaryBtn HoverPrimaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                {{read_lang_word('more1')}}
                <i class="fa-solid fa-arrow-right"></i>
            </a>
        </div>

    </div>
</section>
