<!-- mobli filtering btn -->
<button class="fixed bottom-4 right-4 z-40 lg:hidden shadow-xl  text-white rounded-full w-16 h-16 flex items-center justify-center"
        id="openMobileFilters">
    <i class="fa-solid fa-sliders"></i>
    <span class="sr-only"> {{read_lang_word('filter')}}</span>
</button>
<!-- Mobile Filter Backdrop and Panel -->
<div id="mobileFilterDrawer" class="fixed inset-0 z-50 bg-black bg-opacity-30 hidden">
    <div class="mobileFilterDrawerContent overflow-y-auto absolute bottom-0 left-0 right-0 bg-white rounded-t-3xl p-8 transition-all duration-300  w-full shadow-2xl">
        <button class="mb-4 flex items-center gap-2 secondaryTitle font-bold" id="closeMobileFilters">
            <i class="fa-solid fa-xmark text-lg"></i>
        </button>
        <!-- Place the same filter form used on desktop here -->
        <div class="mobileFilterItems space-y-5">
            @foreach($categories as $cat_faq)
                @if($cat_faq->title == 'Subject Area')
                    <div>
                        <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center ">
                            {{ $cat_faq->title }}
                            <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                        </h3>
                        <div class="flex flex-wrap gap-3 p-5 border hidden transition rounded-b">
                            <!-- All Subject -->
                            <a href="#{{$cat_faq->slug}}" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                                <i class="fa-solid fa-book-open transition-all duration-300 ease-in-out"></i>
                                All Subject
                            </a>
                            @if($cat_faq->children->count())

                                @foreach($cat_faq->children as $child)
                                    <a href="#{{ $child->slug }}" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                                        <i class="fa-solid {{ $child->icon }} transition-all duration-300 ease-in-out"></i>
                                        {{ $child->title }}
                                    </a>
                                @endforeach
                            @endif
                        </div>
                    </div>
                @else

                    <div>
                        <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center">
                            {{ $cat_faq->title }}
                            <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                        </h3>
                        <div class="flex flex-wrap gap-3 p-5 border hidden transition rounded-b">
                            <a href="#{{$cat_faq->slug}}" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                                All Services
                                <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                            </a>
                            @if($cat_faq->children->count())

                                @foreach($cat_faq->children as $child)

                                    <a href="#{{ $child->slug }}" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                                        {{ $child->title }}
                                        <i class="fa-solid {{ $child->icon }} transition-all duration-300 ease-in-out"></i>
                                    </a>
                                @endforeach
                            @endif
                        </div>
                    </div>
                @endif

            @endforeach
        </div>
    </div>
</div>



