<!-- Filter Panel -->
<section class="ّFQ-filter-panel  bg-gray-100">
    <div id="FQ-filter-bar" class="FQ-filter-bar scroll-marginTop1">
        <div class="hidden lg:flex flex-wrap gap-3 max-w-6xl mx-auto px-6 py-4 ">
            @foreach($categories as $cat)
                <a href="#{{ $cat->slug  }}" class="FQItem flex items-center gap-2  px-4 py-2 rounded-lg  transition text-sm  shadow-sm unelectedBarItem">
                    {{ $cat->title }}
                </a>

            @endforeach

        </div>
    </div>
    <div class="max-w-6xl mx-auto px-6 py-12">
        <div class="flex justify-between items-start gap-5">
            <!-- Sidebar Filter Panel -->
            <aside class="FQ-filter-left lg:w-1/4 hidden lg:inline sticky ">
                <!-- 1. Subject Area -->
                @foreach($categories as $cat_faq)
                    @if($cat_faq->title == 'Subject Area')
                        <div class="mb-6 border  bg-white px-5 py-3 rounded-3xl scroll-marginTop2">
                            <h3 class="text-xl font-semibold mb-2 flex items-center gap-2 BlueTitle">{{ $cat_faq->title }}</h3>
                            <div class="flex flex-wrap gap-3">
                                <!-- All Subject -->
                                <a href="#{{ $cat_faq->slug }}" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                                    <i class="fa-solid fa-book-open transition-all duration-300 ease-in-out"></i>
                                    All Subject
                                </a>
                                @if($cat_faq->children->count())

                                    @foreach($cat_faq->children as $child)
                                        <a href="#{{ $child->slug }}" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                                            <i class="fa-solid {{ $child->icon }} transition-all duration-300 ease-in-out"></i>
                                            {{ $child->title }}
                                        </a>
                                    @endforeach
                                @endif


                            </div>
                        </div>
                    @else
                        <div class="mb-6 border bg-white px-5 py-3 rounded-3xl scroll-marginTop2">
                            <h3 class="text-xl font-semibold mb-2 flex items-center gap-2 BlueTitle">{{ $cat_faq->title }}</h3>
                            <div class="flex flex-col gap-2 justify-between items-center">
                                <a href="#{{ $cat_faq->slug }}" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                                    All Services
                                    <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                                </a>
                                @if($cat_faq->children->count())

                                    @foreach($cat_faq->children as $child)
                                        <a href="#{{ $child->slug }}" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                                            {{ $child->title }}
                                            <i class="fa-solid {{ $child->icon }} transition-all duration-300 ease-in-out"></i>
                                        </a>
                                    @endforeach
                                @endif


                            </div>
                        </div>
                    @endif

                @endforeach
            </aside>
            <div  class=" w-full lg:w-3/4 scroll-marginTop2 space-y-5">
                @foreach($category_faq as $category)
                    @if($category->faqs->count() > 0 || $category->children->where('faqs', '!=', collect())->count() > 0)
                        <div  id="{{$category->slug}}" class="bg-white rounded-xl shadow p-4 md:p-8 border border-gray-200 scroll-marginTop2">
                            <h2 class="text-lg md:text-xl lg:text-2xl font-bold mb-6 BlueTitle">{{$category->title}}</h2>
                            <div class="accordion space-y-4">
                                <!-- 1. Math -->
                                @foreach($category->children as $child)
                                    @if($child->faqs->count() > 0)
                                        <div id="{{$child->slug}}" class="scroll-marginTop2 space-y-4">
                                            <h3 class="text-base md:text-lg lg:text-xl font-semibold secondaryTitle">{{ $child->title }}:</h3>
                                            @foreach($child->faqs as $faq)
                                                <div class="accordion-item border border-gray-300 rounded-lg">
                                                    <button class="accordion-header w-full flex justify-between items-center gap-2 px-4 py-3 bg-gray-100 rounded-lg hover:bg-gray-200 transition" onclick="toggleAccordion('faq', 'faq{{ $faq->id }}')">
                                                        <span class="font-medium text-gray-800 text-left">{{ $faq->question }}</span>
                                                        <i id="icon-faq-faq{{ $faq->id }}" class="fa-solid fa-chevron-down w-5 h-5 transform transition-transform"></i>
                                                    </button>
                                                    <div id="content-faq-faq{{ $faq->id }}" class="accordion-body px-4 py-3 text-gray-700 hidden">
                                                        <p>{!! $faq->answer !!}</p>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                @endforeach

                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
</section>
