@extends('front.layouts.front')
@section('body')
    <!-- Hero Section for FAQ Page -->
    <section class="heroSection relative w-full h-screen overflow-hidden bg-gray-900 text-white -mt-20">
        <!-- Background image or video -->
        <img src="{{asset('assets/sapienta/imges/courses.webp') }}" alt="Hero background" class=" inset-0 w-full h-full object-cover opacity-40 z-0">
        <!-- Overlay content -->
        <div class="absolute inset-0 z-10 flex flex-col justify-center items-center h-full text-center px-6">
            <h1 class="text-3xl md:text-4xl font-extrabold mb-8 max-w-6xl">Frequently Asked Questions</h1>
            <p class="text-lg md:text-xl mb-4 max-w-6xl text-gray-100 font-bold">Find Answers Quickly</p>
            <p class="text-lg md:text-xl mb-8 max-w-6xl text-gray-100">
                Explore common questions about Sapienta Academy, our courses, tutoring sessions, AI assistant DiaLogos, and how to get the most out of your learning journey.
            </p>
            <!-- CTA buttons -->
            <div class="flex flex-col md:flex-row gap-4">
                <a href="#FQ-filter-bar" class="heroSectionBtn primaryBtn HoverPrimaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                    Browse FAQs
                </a>
                <a href="./contactUs.html" class="heroSectionBtn HoverPrimaryBtn bgblueBtn bg-white bg-opacity-10 border border-white border-opacity-10 shadow-inner px-6 py-3 rounded-lg font-semibold transition">
                    Still Have Questions?
                </a>
            </div>
        </div>
    </section>
    <!-- mobli filtering btn -->
    <button class="fixed bottom-4 right-4 z-40 lg:hidden shadow-xl  text-white rounded-full w-16 h-16 flex items-center justify-center"
            id="openMobileFilters">
        <i class="fa-solid fa-sliders"></i>
        <span class="sr-only">Filter</span>
    </button>
    <!-- Mobile Filter Backdrop and Panel -->
    <div id="mobileFilterDrawer" class="fixed inset-0 z-50 bg-black bg-opacity-30 hidden">
        <div class="mobileFilterDrawerContent overflow-y-auto absolute bottom-0 left-0 right-0 bg-white rounded-t-3xl p-8 transition-all duration-300  w-full shadow-2xl">
            <button class="mb-4 flex items-center gap-2 secondaryTitle font-bold" id="closeMobileFilters">
                <i class="fa-solid fa-xmark text-lg"></i>
            </button>
            <!-- Place the same filter form used on desktop here -->
            <div class="mobileFilterItems space-y-5">
                <div>
                    <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center ">
                        Subject Area
                        <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                    </h3>
                    <div class="flex flex-wrap gap-3 p-5 border hidden transition rounded-b">
                        <!-- All Subject -->
                        <a href="#all-subject" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-book-open transition-all duration-300 ease-in-out"></i>
                            All Subject
                        </a>

                        <!-- Mathematics -->
                        <a href="#math" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-square-root-variable transition-all duration-300 ease-in-out"></i>
                            Mathematics
                        </a>

                        <!-- Physics -->
                        <a href="#physics" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-atom transition-all duration-300 ease-in-out"></i>
                            Physics
                        </a>

                        <!-- Biology -->
                        <a href="#biology" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-dna transition-all duration-300 ease-in-out"></i>
                            Biology
                        </a>

                        <!-- Chemistry -->
                        <a href="#chemistry" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-flask-vial transition-all duration-300 ease-in-out"></i>
                            Chemistry
                        </a>

                        <!-- History -->
                        <a href="#history" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-landmark transition-all duration-300 ease-in-out"></i>
                            History
                        </a>

                        <!-- French -->
                        <a href="#french" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-language transition-all duration-300 ease-in-out"></i>
                            French
                        </a>

                        <!-- English -->
                        <a href="#english" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-book-open-reader transition-all duration-300 ease-in-out"></i>
                            English
                        </a>

                        <!-- Science -->
                        <a href="#science" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-microscope transition-all duration-300 ease-in-out"></i>
                            Science
                        </a>

                        <!-- Geography -->
                        <a href="#geography" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-globe-europe transition-all duration-300 ease-in-out"></i>
                            Geography
                        </a>

                        <!-- Accounting -->
                        <a href="#accounting" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-calculator transition-all duration-300 ease-in-out"></i>
                            Accounting
                        </a>

                        <!-- Economics -->
                        <a href="#economics" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-chart-line transition-all duration-300 ease-in-out"></i>
                            Economics
                        </a>

                        <!-- Business Student -->
                        <a href="#business" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-briefcase transition-all duration-300 ease-in-out"></i>
                            Business Student
                        </a>

                        <!-- Critical Thinking -->
                        <a href="#critical-thinking" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-brain transition-all duration-300 ease-in-out"></i>
                            Critical Thinking
                        </a>

                        <!-- Philosophy -->
                        <a href="#philosophy" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-scale-balanced transition-all duration-300 ease-in-out"></i>
                            Philosophy
                        </a>

                        <!-- Coding -->
                        <a href="#coding" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-code transition-all duration-300 ease-in-out"></i>
                            Coding
                        </a>                               <!-- All Subject -->
                        <a href="#all-subject" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-book-open transition-all duration-300 ease-in-out"></i>
                            All Subject
                        </a>

                        <!-- Mathematics -->
                        <a href="#math" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-square-root-variable transition-all duration-300 ease-in-out"></i>
                            Mathematics
                        </a>

                        <!-- Physics -->
                        <a href="#physics" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-atom transition-all duration-300 ease-in-out"></i>
                            Physics
                        </a>

                        <!-- Biology -->
                        <a href="#biology" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-dna transition-all duration-300 ease-in-out"></i>
                            Biology
                        </a>

                        <!-- Chemistry -->
                        <a href="#chemistry" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-flask-vial transition-all duration-300 ease-in-out"></i>
                            Chemistry
                        </a>

                        <!-- History -->
                        <a href="#history" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-landmark transition-all duration-300 ease-in-out"></i>
                            History
                        </a>

                        <!-- French -->
                        <a href="#french" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-language transition-all duration-300 ease-in-out"></i>
                            French
                        </a>

                        <!-- English -->
                        <a href="#english" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-book-open-reader transition-all duration-300 ease-in-out"></i>
                            English
                        </a>

                        <!-- Science -->
                        <a href="#science" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-microscope transition-all duration-300 ease-in-out"></i>
                            Science
                        </a>

                        <!-- Geography -->
                        <a href="#geography" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-globe-europe transition-all duration-300 ease-in-out"></i>
                            Geography
                        </a>

                        <!-- Accounting -->
                        <a href="#accounting" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-calculator transition-all duration-300 ease-in-out"></i>
                            Accounting
                        </a>

                        <!-- Economics -->
                        <a href="#economics" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-chart-line transition-all duration-300 ease-in-out"></i>
                            Economics
                        </a>

                        <!-- Business Student -->
                        <a href="#business" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-briefcase transition-all duration-300 ease-in-out"></i>
                            Business Student
                        </a>

                        <!-- Critical Thinking -->
                        <a href="#critical-thinking" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-brain transition-all duration-300 ease-in-out"></i>
                            Critical Thinking
                        </a>

                        <!-- Philosophy -->
                        <a href="#philosophy" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-scale-balanced transition-all duration-300 ease-in-out"></i>
                            Philosophy
                        </a>

                        <!-- Coding -->
                        <a href="#coding" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                            <i class="fa-solid fa-code transition-all duration-300 ease-in-out"></i>
                            Coding
                        </a>
                    </div>
                </div>
                <div>
                    <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center">
                        Educational Services
                        <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                    </h3>
                    <div class="flex flex-wrap gap-3 p-5 border hidden transition rounded-b">
                        <a href="#educationalServices" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                            All Services
                            <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#privateClasses" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                            Private Online Classes
                            <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#educationalResources" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                            Educational Resources (Notes, Exercises, Videos)
                            <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#aiAssistant" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                            AI Assistant (DiaLogos)
                            <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#examPrepPrograms" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                            Supplementary / Exam Preparation Programs
                            <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#academicCounseling" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                            Academic Counseling
                            <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                        </a>
                    </div>
                </div>
                <div>
                    <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center">
                        Support & Technical Issues
                        <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                    </h3>
                    <div class="flex flex-wrap gap-3 p-5 border hidden transition rounded-b">
                        <a href="#supportTechnical" class="supportIssuesBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags">
                            All Topics
                            <i class="fa-solid fa-headset transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#registrationLogin" class="supportIssuesBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags">
                            Registration & Login
                            <i class="fa-solid fa-user-check transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#paymentSubscription" class="supportIssuesBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags">
                            Payment & Subscription Issues
                            <i class="fa-solid fa-credit-card transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#onlinePlatform" class="supportIssuesBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags">
                            Using the Online Platform (Video, Chat, Files)
                            <i class="fa-solid fa-laptop-code transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#supportContact" class="supportIssuesBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags">
                            Support & Contact
                            <i class="fa-solid fa-envelope-open-text transition-all duration-300 ease-in-out"></i>
                        </a>
                    </div>
                </div>
                <div>
                    <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center">
                        Audience
                        <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                    </h3>
                    <div class="flex flex-col gap-3 p-5 border hidden transition rounded-b">
                        <a href="#allAudiences" class="AudienceGroupBtn w-full px-3 py-1 rounded-full text-sm unselectedFilteringTags flex items-center gap-2">
                            All Audiences
                            <i class="fa-solid fa-users transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#parentsAudience" class="AudienceGroupBtn w-full px-3 py-1 rounded-full text-sm unselectedFilteringTags flex items-center gap-2">
                            Parents
                            <i class="fa-solid fa-user-friends transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#studentsAudience" class="AudienceGroupBtn w-full px-3 py-1 rounded-full text-sm unselectedFilteringTags flex items-center gap-2">
                            Students
                            <i class="fa-solid fa-user-graduate transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#teachersAudience" class="AudienceGroupBtn w-full px-3 py-1 rounded-full text-sm unselectedFilteringTags flex items-center gap-2">
                            Teachers / Tutors
                            <i class="fa-solid fa-chalkboard-teacher transition-all duration-300 ease-in-out"></i>
                        </a>
                    </div>
                </div>
                <div>
                    <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center">
                        Learning Model & Philosophy
                        <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                    </h3>
                    <div class="flex flex-col gap-3 p-5 border hidden transition rounded-b">
                        <a href="#learningModel" class="LearningPhilosophyBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            All Topics
                            <i class="fa-solid fa-lightbulb transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#teachingMethod" class="LearningPhilosophyBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            Teaching Method (Curiosity-Driven Learning)
                            <i class="fa-solid fa-brain transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#roleDialogue" class="LearningPhilosophyBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            Role of Dialogue & Interaction
                            <i class="fa-solid fa-comments transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#developingCharacter" class="LearningPhilosophyBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            Developing Academic Character
                            <i class="fa-solid fa-user-shield transition-all duration-300 ease-in-out"></i>
                        </a>
                    </div>
                </div>
                <div>
                    <h3 class="mobileFilterItem font-semibold hover:shadow py-2 rounded text-lg  BlueTitle text-center">
                        Financial Matters
                        <i class="fa-solid fa-chevron-down transition-all duration-300 ease-in-out"></i>
                    </h3>
                    <div class="flex flex-col gap-3 p-5 border hidden transition rounded-b">
                        <a href="#financialMatters" class="FinancialMattersBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            All Topics
                            <i class="fa-solid fa-money-bill-wave transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#feesTuition" class="FinancialMattersBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            Fees & Tuition
                            <i class="fa-solid fa-coins transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#discountsOffers" class="FinancialMattersBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            Discounts & Special Offers
                            <i class="fa-solid fa-tags transition-all duration-300 ease-in-out"></i>
                        </a>
                        <a href="#refundsCancellations" class="FinancialMattersBtn w-full px-3 py-1 rounded-xl text-sm unselectedFilteringTags flex items-center gap-2">
                            Refunds & Cancellations
                            <i class="fa-solid fa-undo transition-all duration-300 ease-in-out"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Filter Panel -->
    <section class="ّFQ-filter-panel  bg-gray-100">
        <div id="FQ-filter-bar" class="FQ-filter-bar scroll-marginTop1">
            <div class="hidden lg:flex flex-wrap gap-3 max-w-6xl mx-auto px-6 py-4 ">
                @foreach($categories as $cat)
                    <a href="#{{ $cat->slug  }}" class="FQItem flex items-center gap-2  px-4 py-2 rounded-lg  transition text-sm  shadow-sm unelectedBarItem">
                        {{ $cat->title }}
                    </a>

                @endforeach

            </div>
        </div>
        <div class="max-w-6xl mx-auto px-6 py-12">
            <div class="flex justify-between items-start gap-5">
                <!-- Sidebar Filter Panel -->
                <aside class="FQ-filter-left lg:w-1/4 hidden lg:inline sticky ">
                    <!-- 1. Subject Area -->
                    @foreach($categories as $cat_faq)
                        @if($cat_faq->title == 'Subject Area')
                        <div class="mb-6 border  bg-white px-5 py-3 rounded-3xl scroll-marginTop2">
                            <h3 class="text-xl font-semibold mb-2 flex items-center gap-2 BlueTitle">{{ $cat_faq->title }}</h3>
                            <div class="flex flex-wrap gap-3">
                                <!-- All Subject -->
                                <a href="#{{ $cat_faq->slug }}" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                                    <i class="fa-solid fa-book-open transition-all duration-300 ease-in-out"></i>
                                    All Subject
                                </a>
                                @if($cat_faq->children->count())

                                        @foreach($cat_faq->children as $child)
                                            <a href="#{{ $child->slug }}" class="subjectFQBtn flex items-center gap-2 px-4 py-2 rounded-full transition text-sm shadow-sm unselectedFilteringTags">
                                                <i class="fa-solid {{ $child->icon }} transition-all duration-300 ease-in-out"></i>
                                                {{ $child->title }}
                                            </a>
                                        @endforeach
                                 @endif


                            </div>
                        </div>
                        @else
                            <div class="mb-6 border bg-white px-5 py-3 rounded-3xl scroll-marginTop2">
                                <h3 class="text-xl font-semibold mb-2 flex items-center gap-2 BlueTitle">{{ $cat_faq->title }}</h3>
                                <div class="flex flex-col gap-2 justify-between items-center">
                                    <a href="#{{ $cat_faq->slug }}" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                                        All Services
                                        <i class="fa-solid fa-circle-check transition-all duration-300 ease-in-out"></i>
                                    </a>
                                    @if($cat_faq->children->count())

                                        @foreach($cat_faq->children as $child)
                                            <a href="#{{ $child->slug }}" class="educationalServicesBtn px-4 py-2 rounded-xl text-sm w-full flex justify-between items-center unselectedFilteringTags">
                                                {{ $child->title }}
                                                <i class="fa-solid {{ $child->icon }} transition-all duration-300 ease-in-out"></i>
                                            </a>
                                        @endforeach
                                    @endif


                                </div>
                            </div>
                        @endif

                    @endforeach
                </aside>
                <div  class=" w-full lg:w-3/4 scroll-marginTop2 space-y-5">
                    @foreach($category_faq as $category)
                        @if($category->faqs->count() > 0 || $category->children->where('faqs', '!=', collect())->count() > 0)
                            <div id="{{ $category->slug }}" class="bg-white rounded-xl shadow p-4 md:p-8 border border-gray-200 scroll-marginTop2">
                                <h2 class="text-lg md:text-xl lg:text-2xl font-bold mb-6 BlueTitle">
                                    {{ $category->title }}
                                </h2>
                                <div class="accordion space-y-4">
                                    {{-- FAQ های دسته اصلی --}}
                                    @foreach($category->faqs as $faq)
                                        <div class="accordion-item border border-gray-300 rounded-lg">
                                            <button class="accordion-header w-full flex justify-between items-center gap-2 px-4 py-3 bg-gray-100 rounded-lg hover:bg-gray-200 transition"
                                                    onclick="toggleAccordion('faq', 'faq{{ $faq->id }}')">
                                                <span class="font-medium text-gray-800 text-left">{{ $faq->question }}</span>
                                                <i id="icon-faq-faq{{ $faq->id }}" class="fa-solid fa-chevron-down w-5 h-5 transform transition-transform"></i>
                                            </button>
                                            <div id="content-faq-faq{{ $faq->id }}" class="accordion-body px-4 py-3 text-gray-700 hidden">
                                                <p>{{ $faq->answer }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                    @foreach($category->children as $child)
                                        @if($child->faqs->count() > 0)
                                            <div id="{{ $child->slug  }}" class="mt-6 space-y-4">
                                                <h4 class="text-base md:text-lg font-semibold">{{ $child->title }}</h4>
                                                @foreach($child->faqs as $faq)
                                                    <div class="accordion-item border border-gray-300 rounded-lg">
                                                        <button class="accordion-header w-full flex justify-between items-center gap-2 px-4 py-3 bg-gray-100 rounded-lg hover:bg-gray-200 transition"
                                                                onclick="toggleAccordion('faq', 'faq{{ $faq->id }}')">
                                                            <span class="font-medium text-gray-800 text-left">{{ $faq->question }}</span>
                                                            <i id="icon-faq-faq{{ $faq->id }}" class="fa-solid fa-chevron-down w-5 h-5 transform transition-transform"></i>
                                                        </button>
                                                        <div id="content-faq-faq{{ $faq->id }}" class="accordion-body px-4 py-3 text-gray-700 hidden">
                                                            <p>{!! $faq->answer !!}</p>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <section class="cta-section py-16 text-white bg-sky-900">
        <div class="cta-container max-w-5xl mx-auto px-6 text-center">

            <!-- Title -->
            <h2 class="cta-title text-2xl sm:text-3xl md:text-4xl font-extrabold mb-6">
                Didn't find the answer you were looking for?
            </h2>

            <!-- CTA Button -->
            <a href="./contactUs.html" class="cta-button secondaryBtn HoversecondaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                Ask your question
            </a>

        </div>
    </section>
@endsection
{{--@section('scripts') @endsection--}}
