@extends('front.layouts.front')

@section('body')
{{--    <!-- Hero Section for Contact Us Page -->--}}
@include('front.includes.hero-section', [
   'title' =>  read_lang($hero,'title'),
   'page'=>  read_lang($hero,'page'),
   'text' => read_lang($hero,'text'),
   'pic' => $hero->header && is_file($hero->header->path)?url($hero->header->path):url('assets/front/img/home1/car-red.png'),
   'button' => read_lang_word('send-message '),
   ])
    <!-- Contact Section -->
    <section id="contact-section" class="contact-section bg-gray-100 py-16 pb-52 px-6 scroll-marginTop1">
        <div class="container max-w-6xl mx-auto">
            <!-- Section Title -->
            <h2 class="text-xl md:text-2xl lg:text-3xl font-extrabold BlueTitle mb-4 text-center">{{read_lang_word('get-in-touch')}}</h2>
            <h3 class="section-subtitle text-lg md:text-xl font-semibold mb-6 text-center">
                {{read_lang_word('desc-get-in-touch')}}

            </h3>

            <!-- Form and Image Wrapper -->
            <div class="form-image-wrapper flex flex-col lg:flex-row justify-between gap-10">
                <!-- Contact Form Column -->
                <div class="contact-form-container w-full lg:w-3/4 ">
                    <!-- Contact Form -->
                    @if(session('success'))
                        <div id="confirmationMessage" class="confirmation-message  mt-8 text-green-600 font-semibold text-center">
                            {{ session('success') }}
                        </div>
                    @endif
                        <form action="{{route('front.contact.us.post')}}" class="contact-form space-y-6" method="post" id="form_req_search_form">
                        @csrf

                        <!-- Input Fields Grid -->
                        <div class="form-grid grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Full Name Input -->
                            <div class="form-field">
                                <label for="fullName" class="form-label block font-semibold mb-2 secondaryTitle"> {{read_lang_word('name')}}</label>
                                <div class="input-wrapper relative">
                            <span class="input-icon absolute top-2 right-4 text-lg text-green-400">
                            <i class="fa-solid fa-user"></i>
                            </span>
                                    <input id="fullName" name="name" type="text" required placeholder="{{read_lang_word('name')}}" value="{{old('name')}}"
                                           class="form-input py-2 pr-11 pl-3 w-full border rounded-lg focus:outline-none focus:ring-2">
                                </div>
                            </div>

                            <!-- Email Address Input -->
                            <div class="form-field">
                                <label for="email" class="form-label block font-semibold mb-2 secondaryTitle">{{read_lang_word('email-address')}}</label>
                                <div class="input-wrapper relative">
                            <span class="input-icon absolute top-2 right-4 text-lg text-red-400">
                            <i class="fa-solid fa-envelope"></i>
                            </span>
                                    <input id="email" name="email" type="email" required placeholder="{{read_lang_word('email')}}" value="{{old('email')}}"
                                           class="form-input py-2 pr-11 pl-3 w-full border rounded-lg focus:outline-none focus:ring-2">
                                </div>
                            </div>

                            <!-- Subject Dropdown -->
                            <div class="form-field">
                                <label for="subject" class="form-label block font-semibold mb-2 secondaryTitle">{{read_lang_word('subject')}}</label>
                                <select id="subject" name="subject" required class="form-select w-full p-3 border rounded-lg shadow-sm">
                                    <option value="">Select a topic</option>
                                    <option value="general">General Inquiry</option>
                                    <option value="support">Technical Support</option>
                                    <option value="admissions">Admissions</option>
                                    <option value="collaboration">Partnership/Collaboration</option>
                                </select>
                            </div>

                            <!-- File Upload Input -->
                            <div class="form-field">
                                <label for="attachment" class="form-label block font-semibold mb-2 secondaryTitle">{{read_lang_word('attachment')}}</label>
                                <input type="file" id="attachment" name="attachment"
                                       class="form-file-input bg-white w-full px-4 py-2 border rounded-lg shadow-sm file:cursor-pointer">
                            </div>
                        </div>

                        <!-- Message Textarea -->
                        <div class="form-field">
                            <label for="message" class="form-label block font-semibold mb-2 secondaryTitle">{{read_lang_word('msg-text')}}</label>
                            <textarea id="message" name="message" rows="5" required placeholder="{{read_lang_word('msg-text')}}"
                                      class="form-textarea w-full px-4 py-3 border rounded-lg focus:ring-2 focus:outline-none resize-none">{{old('message')}}</textarea>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit"
                                class="submit-button  primaryBtn HoverPrimaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                            {{read_lang_word('submit-form')}}
                        </button>
                    </form>

                    <!-- Success Message -->
                    {{--                    <div id="confirmationMessage" class="confirmation-message  mt-8 text-green-600 font-semibold text-center">--}}
                    {{--                        ✅ Your message has been sent successfully. We’ll get back to you shortly.--}}
                    {{--                    </div>--}}
                </div>

                <!-- Image Column -->
                <div class="contact-image w-full lg:w-1/4 flex justify-center items-center">
                    <img src="{{asset('assets/sapienta/imges/math.webp') }}" alt="Sapienta R&D Lab"
                         class="form-side-image w-full max-w-xs rounded-full shadow-lg scale1">
                </div>
            </div>
        </div>
    </section>
    <!-- Contact Info Section -->
    <section class="contact-info-section  py-12 px-6 max-w-6xl mx-auto rounded-3xl -mt-48 mb-10 shadow hover:shadow-lg gradientBtn1">
        <!-- Info Title -->
        <h3 class="info-title text-3xl font-extrabold BlueTitle text-center mb-4">{{read_lang_word('contact-information')}}</h3>
        <p class="info-subtitle text-center secondaryTitle mb-8">
            {{read_lang_word('description-contact')}}
        </p>

        <!-- Info Grid -->
        <div class="info-grid grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Contact Details List -->
            <ul class="contact-details space-y-6">
                <li class="flex items-center gap-3">
                    <i class="fa-solid fa-envelope text-red-400 text-2xl"></i>
                    <span>
                        <span class="font-bold "> {{read_lang_word('email')}}:</span>
                        <a href="{{read_lang($item,'email')}}" class="hover:underline ">{{read_lang($item,'email')}}</a>
                    </span>
                </li>
                <li class="flex items-center gap-3">
                    <i class="fa-solid fa-phone text-yellow-300 text-2xl"></i>
                    <span>
                        <span class="font-bold">{{read_lang_word('phone')}}:</span>
                @if(!blank($item->phone) && count(explode(',',$item->phone)))
                            @foreach(explode(',',$item->phone) as $key=>$phone)
                                @if($key == 0)
                                    <a href="{{str_replace([' ','+','-','(',')'],'',$phone)}}" class="hover:underline ">{{$phone}}</a>
                                @endif
                            @endforeach
                        @endif


                    </span>
                </li>
                <li class="flex items-center gap-3">
                    <i class="fa-solid fa-location-dot text-green-300 text-2xl"></i>
                    <span class="">
                        <span class="font-bold">{{read_lang_word('address')}}:</span> {{read_lang($item,'address')}}
                    </span>
                </li>
                <li class="flex items-center gap-3">
                    <i class="fa-solid fa-clock text-purple-400 text-2xl"></i>
                    <span class="">
                        <span class="font-bold">{{read_lang_word('office-hours')}}:</span>{{read_lang($item,'day_of_week')}} , {{read_lang($item,'day_of_time')}}
                    </span>
                </li>
            </ul>

            <!-- Social Media Section -->
            <div class="social-media-box p-8 rounded-xl flex flex-col items-center justify-center">
                <div class="social-title font-bold text-lg text-center mb-4 ">
                    {{read_lang_word('connect-social')}}
                </div>
                <!-- Icons -->

                <div class="social-icons flex space-x-6">
                    @if($item->telegram || $item->instagram || $item->facebook || $item->twitter || $item->youtube || $item->linkedin || $item->aparat || $item->whatsapp_group)
                        <hr class="mt-30 mb-40">
                        <h6 class="mb-3">{{read_lang_word('social')}}</h6>
                        <div class="contact-social">
                            @if($item->telegram)
                                <a href="{{$item->telegram}}" target="_blank" rel="noopener"
                                   class="text-blue-600 hover:text-blue-800 scale1 transition"><i class="fab fa-telegram fa-xl"></i></a>
                            @endif
                            @if($item->instagram)
                                <a href="{{$item->instagram}}" target="_blank" rel="noopener"
                                   class="text-pink-600 hover:text-pink-800 scale1 transition"><i class="fab fa-instagram fa-xl"></i></a>
                            @endif
                            @if($item->facebook)
                                <a href="{{$item->facebook}}" target="_blank" rel="noopener"
                                   class="text-pink-600 hover:text-pink-800 scale1 transition"><i class="fab fa-facebook fa-xl"></i></a>
                            @endif
                            @if($item->twitter)
                                <a href="{{$item->twitter}}" target="_blank" rel="noopener"
                                   class="text-blue-400 hover:text-blue-600 scale1 transition"><i class="fab fa-twitter fa-xl"></i></a>
                            @endif
                            @if($item->linkedin)
                                <a href="{{$item->linkedin}}" target="_blank" rel="noopener"
                                   class="text-blue-600 hover:text-blue-800 scale1 transition"><i class="fab fa-linkedin fa-xl"></i></a>
                            @endif
                            @if($item->youtube)
                                <a href="{{$item->youtube}}" target="_blank" rel="noopener"
                                   class="text-red-500 hover:text-red-700 scale1 transition"><i class="fab fa-youtube fa-xl"></i></a>
                            @endif
                            @if($item->aparat)
                                <a href="{{$item->aparat}}" target="_blank" rel="noopener"
                                   class="text-red-500 hover:text-red-700 scale1 transition"><i class="fab fa-aparat fa-xl"></i></a>
                            @endif
                            @if($item->whatsapp_group)
                                <a href="{{$item->whatsapp_group}}" target="_blank" rel="noopener"
                                   class="text-red-500 hover:text-red-700 scale1 transition"><i class="fab fa-whatsapp fa-xl"></i></a>
                            @endif
                        </div>
                    @endif






                </div>
            </div>
        </div>
    </section>
    <!-- Google Map Section -->
    <section id="location" class="bg-white py-20 px-6 md:px-12 lg:px-24 ">
        <div class="max-w-6xl mx-auto text-center">
            <!-- Section Title -->
            <h2 class="text-xl md:text-2xl lg:text-3xl font-extrabold BlueTitle mb-4">{{read_lang_word('visit-our-academy')}}</h2>
            <p class="text-lg secondaryTitle mb-10 max-w-2xl mx-auto">
                {{read_lang_word('desc-visit-academy')}}
            </p>

            <!-- Google Map -->
            @if(!blank($item->address_iframe))
                <div class="w-full h-80 rounded-xl overflow-hidden shadow-lg border border-gray-200">
                    {!! $item->address_iframe !!}
                </div>
        @endif
        <!-- Optional Contact Button -->
            <div class="mt-8">
                <a href="#contact" class="inline-flex items-center gap-2 bg-sky-600 hover:bg-sky-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-300">
                    <i class="fa-solid fa-envelope"></i> {{read_lang_word('title-contact')}}
                </a>
            </div>
        </div>
    </section>
    <!-- CTA -->
    <section class="about-page-cta-section py-16 px-6 text-center text-white bg-sky-700">
        <div class="max-w-6xl mx-auto">
            <h2 class="text-3xl font-extrabold mb-4">
                {{read_lang_word('start-conversation')}}
            </h2>
            <p class="mb-8 text-lg">question
                {{read_lang_word('question')}}
            </p>
            <a href="#contact-form" class="cta-button secondaryBtn HoversecondaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                {{read_lang_word('submit-now')}}
                <i class="fa-solid fa-arrow-right"></i>
            </a>
        </div>
    </section>
@endsection
{{--@section('scripts')--}}
{{--    @include('front.includes.req')--}}
{{--@endsection--}}
