<!-- Sidebar  -->
<aside class="lg:w-1/4">
    <!-- Search Box -->
    <div id="SearchBlog" class="mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl  scroll-marginTop1">
        <form method="GET" action="{{ route('front.blog.list') }}">
            <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
                {{read_lang_word('search-blog')}}
            </h3>
            <div class="relative">
                <input type="text" name="q" value="{{ request('q') }}" placeholder="{{read_lang_word('search-articles')}}" class="w-full border border-gray-300 rounded-full py-2 px-4 pr-10 text-sm focus:outline-none focus:ring-2 focus:ring-sky-600">
                <i class="fa-solid fa-magnifying-glass absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
            </div>
        </form>
    </div>
    <!-- Popular Posts -->
    <div  id="PopularPosts" class="PopularPosts mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl  scroll-marginTop1">
        <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
            {{read_lang_word('popular-post')}}
        </h3>
        <ul class="space-y-3 text-sm ">
            @include('front.blog.includes.popular_posts')

        </ul>
    </div>
    <!-- Blog Categories -->
    <div  id="BlogCategories" class="BlogCategories mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl  scroll-marginTop1">
        <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
            {{read_lang_word('blog-category')}}
        </h3>
        <div class="flex flex-col items-start gap-2">
            @foreach($categories as $category)
                <a href="{{ route('front.blog.list', array_merge(request()->all(), ['category' => $category->slug])) }}" class="categoriesItem px-3 py-1 text-sm transition border-b  w-full text-left last:border-b-0">
                    {{$category->title}}
                </a>

            @endforeach

        </div>
    </div>
    <!-- Tags Cloud -->
    <div  id="TagsCloud" class="mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl  scroll-marginTop1">
        <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
            {{read_lang_word('tags-cloud')}}
        </h3>
        <div class="flex flex-wrap gap-2 text-xs">
            @foreach($tags as $tag)
                <a href="{{ route('front.blog.list', array_merge(request()->all(), ['tag' => $tag->id])) }}"
                   class="px-2 py-1 {{ $tagColors[$tag->id] ?? 'bg-gray-500' }} rounded-full text-white transition hover:{{ str_replace('500','800', $tagColors[$tag->id] ?? 'bg-gray-500') }}">
                    {{ $tag->title }}
                </a>
            @endforeach
        </div>

    </div>
    <!-- Reading Time Filter -->
    <div  id="ReadingTimeFilter" class="mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl  scroll-marginTop1">
        <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
            {{read_lang_word('filter-time')}}
        </h3>
        <div class="flex flex-col gap-2">
            @foreach($readingFilters as $filter)
                <a href="{{ route('front.blog.list', array_merge(request()->all(), ['reading' => $filter])) }}" class="w-full text-left text-sm px-4 py-2 rounded-full bg-gray-100 hover:bg-gray-200 transition">
                    {{ $filter }}
                </a>


            @endforeach

        </div>
    </div>
    <!-- Newsletter Signup -->
    <div  id="NewsletterSignup" class="mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl  scroll-marginTop1">
        <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
            {{read_lang_word('join-newsletter')}}
        </h3>
        <p class="text-sm text-justify mb-3">
            {{read_lang_word('latest-articles')}}
        </p>
        <input type="email" placeholder="{{read_lang_word('enter-email')}}" class="w-full border border-gray-300 rounded-full py-2 px-4 text-sm mb-4 focus:outline-none focus:ring-2 focus:ring-sky-600">
        <button class="primaryBtn HoverPrimaryBtn text-white px-4 py-1 rounded-lg font-semibold transition ">
            {{read_lang_word('subscribe')}}
        </button>
    </div>
    <!-- Ask DiaLogos -->
    <div  id="AskDiaLogos" class="mb-6 border bg-gray-50 hover:bg-gray-100 hover:shadow-md px-5 py-3 rounded-3xl scroll-marginTop1">
        <h3 class="text-lg font-semibold mb-3 flex items-center gap-2 BlueTitle">
            {{read_lang_word('ask-dialogos')}}
        </h3>
        <p class="text-sm text-gray-700 mb-3">
            {{read_lang_word('finding-content')}}
        </p>
        <button class="primaryBtn HoverPrimaryBtn text-white px-4 py-1 rounded-full font-semibold transition w-full">
            {{read_lang_word('chat-now')}}
        </button>
    </div>
</aside>
