<section id="blogCommentsSection" class="max-w-4xl mx-auto py-5 border-t border-gray-200 mt-10 scroll-marginTop1" >

    <!-- Title -->
    <h3 class="text-xl font-bold mb-4 BlueTitle">{{read_lang_word('comment')}}</h3>
    @if(session('success'))
        <div id="confirmationMessage" class="confirmation-message mt-3 mb-3 text-green-600 font-semibold text-center bg-green-100 border border-green-400 p-4 rounded">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div id="confirmationMessage" class="confirmation-message mt-3 mb-3 text-red-600 font-semibold text-center bg-red-100 border border-red-400 p-4 rounded">
            {{ session('error') }}
        </div>

    @endif
    @guest
        <div class="flex justify-start gap-2 flex-wrap secondaryTitle mb-4">
            <div>
                <i class="fa-solid fa-user"></i>
                {{read_lang_word('login-post-comment')}}
            </div>
            <div class="">
                <button onclick="openLoginModal()" href="#" class=" flex items-center space-x-2 ">
                    <i class="fa-solid fa-right-to-bracket"></i>
                    <span>{{read_lang_word('login')}}</span>
                </button>
            </div>
        </div>
    @endguest

<!-- Previous Comments -->
    <div class="space-y-6 mb-10 ">
    @foreach($comments as $comment)
        <!-- Comments Container -->
            @include('front.blog.includes.comment')
        @endforeach
    </div>

    <!-- Comment Form -->
    @auth
        <h4 class="text-lg font-semibold mb-4 BlueTitle">{{read_lang_word('leave-comment')}}</h4>
        <form action="{{ route('front.send.comment', $item->id) }}" method="POST" class="space-y-4 selectedFilteringTags p-4">
            @csrf
            <input type="hidden" name="blog_id" value="{{$item->id}}">
            <textarea rows="4" name="description" placeholder="{{read_lang_word('your-comment')}}" required class="w-full  border rounded p-2 border border-gray-300 text-sm mb-4 focus:outline-none focus:ring-2 "></textarea>

            <!-- Simple CAPTCHA -->

            <div class="flex items-center gap-2">
                <div class="g-recaptcha text-sm text-gray-600" data-theme="light" data-size="normal" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
            </div>

            <button type="submit" class="primaryBtn HoverPrimaryBtn text-white px-6 py-2 rounded font-semibold transition">
                {{read_lang_word('post-comment')}}
            </button>
        </form>
    @endauth

</section>
