<section class="mt-5">
    <h3 class="text-xl font-bold mb-4 BlueTitle">{{read_lang_word('author')}}</h3>
    <div class=" px-6 py-10 flex flex-col md:flex-row items-center space-x-6 bg-gray-50 rounded-xl shadow-md">
        <!-- Author Image -->
        <img src="{{$item->user->photo && is_file($item->user->photo->path)?url($item->user->photo->path): url('assets/admin/images/admin.jpg')}}" alt="Author John Doe" class="w-20 h-20 rounded-full object-cover shadow-lg scale1">
        <!-- Author Info -->
        <div>
            <h4 class="text-lg font-bold BlueTitle mb-1">{{$item->user->name}}</h4>
            <p class="text-sm text-gray-600 mb-2">
                {{ $item->user->instructorProfile->bio ?? 'این نویسنده هنوز بیوگرافی وارد نکرده است.' }}
            </p>
            <!-- Social Icons -->
            <div class="flex space-x-3 text-gray-500">
                @if($item->user->instructorProfile)
                    @if($item->user->instructorProfile->twitter)
                        <a href="{{ $item->user->instructorProfile->twitter }}" class="hover:text-blue-500 transition"><i class="fab fa-twitter"></i></a>
                    @endif
                    @if($item->user->instructorProfile->linkedin)
                        <a href="{{ $item->user->instructorProfile->linkedin }}" class="hover:text-blue-700 transition"><i class="fab fa-linkedin"></i></a>
                    @endif
                    @if($item->user->instructorProfile->facebook)
                        <a href="{{ $item->user->instructorProfile->facebook }}" class="hover:text-gray-700 transition"><i class="fab fa-facebook"></i></a>
                    @endif
                    @if($item->user->instructorProfile->whatsapp)
                        <a href="{{ $item->user->instructorProfile->whatsapp }}" class="hover:text-gray-700 transition"><i class="fab fa-whatsapp"></i></a>
                    @endif
                    @if($item->user->instructorProfile->telegram)
                        <a href="{{ $item->user->instructorProfile->telegram }}" class="hover:text-gray-700 transition"><i class="fab fa-telegram"></i></a>
                    @endif
                    @if($item->user->instructorProfile->instagram)
                        <a href="{{ $item->user->instructorProfile->instagram }}" class="hover:text-gray-700 transition"><i class="fab fa-instagram"></i></a>
                    @endif
                    @if($item->user->instructorProfile->youtube)
                        <a href="{{ $item->user->instructorProfile->youtube }}" class="hover:text-gray-700 transition"><i class="fab fa-youtube"></i></a>
                    @endif
                @endif
            </div>
        </div>
    </div>
</section>
