<section class="relative w-full h-screen overflow-hidden bg-gray-900 text-white -mt-20">
    <!-- Background image -->
    <img src="{{asset('assets/sapienta/imges/banner.webp') }}" alt="Blog Detail Background" class="inset-0 w-full h-full object-cover opacity-40 z-0">

    <!-- Overlay content -->
    <div class="absolute inset-0 z-10 flex flex-col justify-center items-center h-full text-center px-6">
        <!-- Blog Title -->
        <h1 class="text-3xl md:text-4xl font-extrabold mb-6 max-w-5xl leading-snug">
            {{read_lang($item,'title')}}
        </h1>

        <!-- Meta Info -->
        <div class="flex flex-wrap justify-center gap-4 text-sm text-gray-200 mb-6">
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-user text-blue-400"></i> {{$item->user->name}}
            </div>
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-calendar text-purple-400"></i> {{ $item->created_at->toFormattedDateString() }}
            </div>
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-tag text-green-400"></i> {{$item->category->title}}
            </div>
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-clock text-yellow-400"></i> {{$item->reading_time}} min read
            </div>
        </div>

        <!-- Short Description -->
        <p class="text-lg md:text-xl mb-8 max-w-4xl text-gray-100">
            Discover effective, research-backed techniques to improve your mathematical thinking and develop a growth mindset toward learning.
        </p>

        <!-- CTA buttons -->
        <div class="flex flex-col sm:flex-row gap-4">
            <a href="{{route('front.blog.list')}}" class="heroSectionBtn primaryBtn HoverPrimaryBtn text-white px-6 py-3 rounded-lg font-semibold transition">
                Back to Blog
            </a>
            <a href="#blogCommentsSection" class="heroSectionBtn HoverPrimaryBtn bgblueBtn bg-gray-50 hover:bg-gray-100 hover:shadow-md bg-opacity-10 border border-white border-opacity-10 shadow-inner px-6 py-3 rounded-lg font-semibold transition">
                Leave a Comment
            </a>
        </div>
    </div>
</section>
