@php
    $depth = $depth ?? 0;
    if ($depth === 0) {
        $bgClass = 'bg-blue-50';
    } else {
        $bgClass = $depth % 2 === 0 ? 'bg-gray-100' : 'bg-white';
    }
@endphp

<div class="comment {{ $bgClass }} p-3 rounded-lg shadow-sm">
    <div class="flex items-start gap-4">
        <img src="{{$comment->user->photo && is_file($comment->user->photo->path)?url($comment->user->photo->path): url('assets/admin/images/admin.jpg')}}"
             alt="User"
             class="w-10 h-10 rounded-full object-cover">

        <div class="flex-1">
            <div class="flex justify-between items-center mb-1">
                <h4 class="font-semibold">{{ $comment->user->name }}</h4>
                <span class="text-xs text-gray-400">{{ $comment->created_at->toFormattedDateString() }}</span>
            </div>

            <p class="text-sm text-gray-600 mb-2">{{ $comment->description }}</p>

            @auth
                <button class="text-sm text-blue-600 hover:underline reply-btn">Reply</button>
                <div class="mt-3 hidden reply-form">
                    <form action="{{ route('front.send.comment', $item->id) }}" method="POST">
                        @csrf
                        <input type="hidden" name="parent_id" value="{{ $comment->id }}">
                        <textarea name="description" class="w-full border rounded p-2 text-sm mb-2" rows="2" placeholder="Write your reply..."></textarea>
                        <button class="primaryBtn HoverPrimaryBtn text-white px-4 py-1 rounded text-sm">{{read_lang_word('submit-reply')}}</button>
                    </form>
                </div>
            @endauth

            @if($comment->replies->count())
                <div class="replies ml-10 mt-3 space-y-3 hidden">
                    @foreach($comment->replies as $reply)
                        @include('front.blog.includes.comment', ['comment' => $reply, 'depth' => $depth + 1])
                    @endforeach
                </div>

                <button class="toggle-replies-btn text-sm text-gray-500 mt-2">
                    {{read_lang_word('views ')}} {{ $comment->replies->count() }} {{read_lang_word('replies')}}
                </button>
            @endif
        </div>
    </div>
</div>
