@if($item)

  <!-- Image Section with Category Badge -->
  <div class="course-image-wrapper relative">
      <img src="{{$item->photo && is_file($item->photo->path)?url($item->photo->path):url('assets/front/img/home1/blog-1.jpg')}}" alt="Blog Post Image"
           class="course-image w-full h-48 object-cover transition-transform duration-500 ease-in-out scale1">

      <!-- Category Badge -->
      <div class="badge badge-left absolute top-0 left-0 m-2 ">
            <span class="badge-math text-xs px-2 py-1 rounded-full flex items-center gap-1 bg-green-100 text-green-600">
            <i class="fa-solid fa-lightbulb"></i> {{$item->category->title}}
            </span>
      </div>
  </div>

  <!-- Blog Content -->
  <div class="blog-content p-4 text-sm">
      <!-- Title -->
      <h3 class="blog-title text-lg font-bold mb-2 line-clamp-2">
          {{read_lang($item,'title')}}
      </h3>

      <!-- Description -->
      <div class="blog-desc text-sm text-gray-700 dark:text-gray-300 mb-4 text-justify line-clamp-4">
            {!! read_lang($item,'excerpt') !!}
      </div>

      <!-- Meta Info -->
      <div class="grid grid-cols-2 gap-3 text-xs text-gray-700 dark:text-gray-300 mb-5">
          <div class="flex items-center gap-2">
              <i class="fa-solid fa-user text-blue-600 transition-all duration-300 ease-in-out"></i>
              {{$item->user->name}}
          </div>
          <div class="flex items-center gap-2">
              <i class="fa-solid fa-calendar text-purple-600 transition-all duration-300 ease-in-out"></i>
              {{ $item->created_at->toFormattedDateString() }}
          </div>
          <div class="flex items-center gap-2">
              <i class="fa-solid fa-tag text-green-600 transition-all duration-300 ease-in-out"></i>
              @foreach($item->tags_list as $tag)
                  {{ $tag->title }}@if(!$loop->last), @endif
              @endforeach

          </div>
          <div class="flex items-center gap-2">
              <i class="fa-solid fa-comments text-yellow-400 transition-all duration-300 ease-in-out"></i>
              3 Comments
          </div>
      </div>

      <!-- Call to Action Button -->
      <a href="{{route('front.blog.show', $item->slug)}}" class="blog-btn primaryBtn HoverPrimaryBtn text-white px-5 py-2 rounded-lg font-semibold transition">{{read_lang_word('more')}}</a>
  </div>

@endif

