<div  class=" w-full lg:w-3/4 lg:order-2 ">
    <!-- Blog Article Content -->
    <article class=" lg:px-6 text-justify">
        <!-- Featured Image -->
        <img src="{{$item->photo && is_file($item->photo->path)?url($item->photo->path):url('assets/front/img/home1/blog-1.jpg')}}" alt="Featured Image" class="w-full h-96 rounded-xl shadow-md mb-8">
        <div class="space-y-6 border-b pb-5">
            <!-- Subheading -->
            <h2 class="text-lg md:text-xl lg:text-2xl font-bold  BlueTitle"> {{read_lang($item,'title')}}</h2>
            <!-- Introduction Paragraph -->
            <p class="text-lg">
                {!! read_lang($item,'excerpt') !!}
            </p>
            <!-- Meta Information -->
            <div class="flex flex-wrap gap-3 text-sm ">
                <span><i class="fa-solid fa-user text-red-500"></i> Author: <span class="font-medium"> {{$item->user->name}}</span></span>
                <span><i class="fa-solid fa-calendar-days text-yellow-400"></i> Date: <span class="font-medium"> {{ $item->created_at->toFormattedDateString() }}</span></span>
                <span><i class="fa-solid fa-tags text-pink-400"></i> Tags: <span class="font-medium">
                       @foreach($item->tags_list as $tag)
                            {{ $tag->title }}@if(!$loop->last), @endif
                        @endforeach
                                </span></span>
            </div>
            <!-- The Science of Forgetting -->
        {!! read_lang($item,'text') !!}
        <!-- Blockquote -->
            <blockquote class="border-l-4 border-blue-500 pl-4 italic text-gray-700 mb-6">
               {{ read_lang($item,'quotation')  }}
            </blockquote>
        </div>
    <!-- Conclusion -->
        <h2 class="text-xl md:text-2xl lg:text-3xl font-bold mb-4 BlueTitle mt-4">{{read_lang_word('final-thought')}}</h2>
        <p class="mb-6">
            {{ read_lang($item,'content')  }}
        </p>
        <!-- End CTA -->
        <div class="bg-blue-50 p-6 rounded-xl border text-center selectedFilteringTags">
            <h3 class="text-xl font-bold mb-2">
               {{ read_lang_word('you-need-help')}}
            </h3>
            <p class="mb-4 text-gray-700">{{read_lang_word('learning-journey-today')}}</p>
            <a href="{{route('front.contact.us')}}" class="primaryBtn HoverPrimaryBtn text-white px-6 py-2 rounded-lg font-semibold transition">
                {{read_lang_word('free-consultation')}}
            </a>
        </div>
        <!-- Social Share Section -->
        <section class="py-10 border-t border-b border-gray-200 mt-10">
            <h3 class="text-xl font-bold mb-4 BlueTitle">{{read_lang_word('share-article')}}</h3>
            @if($item->telegram || $item->instagram || $item->facebook || $item->twitter  || $item->linkedin )
                <div class="flex space-x-4">
                    @if($item->telegram)
                        <a href="{{$item->telegram}}" class="flex items-center justify-center w-10 h-10 bg-blue-600 text-white rounded-full hover:bg-blue-700 transition transform hover:scale-110">
                            <i class="fab fa-telegram"></i>
                        </a>
                    @endif
                    @if($item->instagram)
                        <a href="{{$item->instagram}}" class="flex items-center justify-center w-10 h-10 bg-red-600 text-white rounded-full hover:bg-red-700 transition transform hover:scale-110">
                            <i class="fab fa-instagram"></i>
                        </a>
                    @endif
                    @if($item->facebook)
                        <a href="{{$item->facebook}}" class="flex items-center justify-center w-10 h-10 bg-blue-600 text-white rounded-full hover:bg-blue-700 transition transform hover:scale-110">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                    @endif
                    @if($item->twitter)
                        <a href="{{$item->twitter}}" class="flex items-center justify-center w-10 h-10 bg-blue-400 text-white rounded-full hover:bg-blue-500 transition transform hover:scale-110">
                            <i class="fab fa-twitter"></i>
                        </a>
                    @endif

                    @if($item->linkedin)
                        <a href="{{$item->linkedin}}" class="flex items-center justify-center w-10 h-10 bg-blue-800 text-white rounded-full hover:bg-blue-900 transition transform hover:scale-110">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    @endif
                        <a href="{{route('front.blog.show',$item->slug)}}" target="_blank" class="flex items-center justify-center w-10 h-10 bg-gray-600 text-white rounded-full hover:bg-gray-700 transition transform hover:scale-110">
                            <i class="fa-solid fa-link"></i>
                        </a>
                </div>
            @endif

        </section>
        <!-- Author Box -->
    @include('front.blog.includes.section-author')
        <!-- Comments Section -->
        @include('front.blog.includes.section-comment')


    </article>
</div>
