@extends('front.layouts.front')

@section('body')
    @include('front.includes.hero-section', [
    'title' =>  read_lang($hero,'title'),
    'page'=>  read_lang($hero,'page'),
    'text' => read_lang($hero,'text'),
    'pic' => $hero->header && is_file($hero->header->path)?url($hero->header->path):url('assets/front/img/home1/car-red.png'),
    'button' => read_lang_word('about-mission'),
    'button2' => read_lang_word('about-team'),
    ])
    <!-- R&D Section -->
    <section class="rAndDSection relative w-full bg-gray-100  py-20 px-6">
        <div class="rAndDWrapper max-w-6xl mx-auto flex flex-col lg:flex-row items-start gap-10">

            <!-- Text Content -->
            <div class="rAndDText lg:w-1/2 text-center md:text-left">
                <h2 class="rAndDTitle text-xl md:text-2xl lg:text-3xl  font-extrabold  mb-4">
                    {{read_lang($item,'title')}}
                </h2>
                <h3 class="rAndDSubtitle text-xl md:text-2xl font-semibold mb-6">
                    {{read_lang($item,'text2')}}
                </h3>
                <div class="rAndDParagraph text-gray-700 dark:text-gray-300 mb-8  text-justify ">
                    {!! read_lang($item,'text') !!}
                </div>

                <!-- CTA Button -->
                <a href="#rnd" class="rAndDLink heroSectionBtn primaryBtn HoverPrimaryBtn text-white px-6 py-3 mt-5 rounded-lg font-semibold transition">
                    {{read_lang_word('follow-research')}}
                    <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>

            <!-- Image Content: Two overlapping images -->
            <div class="rAndDImage lg:w-1/2 relative sm:mx-auto mb-10">
                <!-- Background Image (rotated) -->
                <div class="absolute top-24 left-32 sm:top-32 sm:left-48 h-32 w-40 sm:w-56 sm:h-40 md:w-64 md:h-48 rounded-xl shadow-lg  overflow-hidden  ">
                    <img src="{{$item->photo && is_file($item->photo->path)?url($item->photo->path):url('assets/front/img/home1/car-red.png')}}" alt="{{photo_alt($item,'photo',read_lang($item,'title'))}}" class="w-full h-full object-cover opacity-95 scale1">
                </div>
                <!-- Foreground Image -->
                <div class="ml-5 sm:ml-0 z-10 w-40 h-32 sm:w-56 sm:h-40 md:w-64 md:h-48 rounded-xl shadow-xl overflow-hidden">
                    <img src="{{$item->photo2 && is_file($item->photo2->path)?url($item->photo2->path):url('assets/front/img/home1/car-red.png')}}" alt="{{photo_alt($item,'photo2',read_lang($item,'title'))}}" class="w-full h-full object-cover scale1">
                </div>
            </div>

        </div>
    </section>
    <!--  Our Mission -->
    @include('front.includes.mission_card')
    <!--  Our Vision -->
    @include('front.includes.vision_card')
    <!--  Our Team -->
    @include('front.includes.team_card')
    <!-- Trusted by -->
    @include('front.includes.approved-section')

    <!-- CTA -->
    @include('front.includes.cta-section', [
'title' => read_lang_word('ready-explore'),
 'subtitle' => read_lang_word('educational-path'),
'button' => read_lang_word('explore-courses'),
'link' => ''
])



@endsection
{{--@section('scripts') @endsection--}}
