@extends('admin.layouts.sepienta')
@section('content')
    <section class="page-section login-page">
        <div class="full-width-screen">
            <div class="container-fluid">
                <div class="content-detail">
                    <!-- Signup form -->
                    <form class="signup-form" method="POST" action="{{ route('register') }}">
                        @csrf
                        <div class="imgcontainer">
                            <img src="{{asset($logo && $logo->logo && is_file($logo->logo->path)?$logo->logo->path:'')}}" alt="logo" class="w-50 avatar">
                        </div>
                        <div class="input-control">
                            <div class="row p-l-5 p-r-5">
                                <div class="col-md-6 p-l-10 p-r-10">
                                    <input type="text" placeholder="Enter your name" class="@error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6 p-l-10 p-r-10">
                                    <input type="email" placeholder="Enter your Email" name="email" value="{{ old('email') }}" required autocomplete="email" class="@error('email') is-invalid @enderror" required>
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6 p-l-10 p-r-10">
                                    <input type="password" placeholder="Enter Password  @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" >
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6 p-l-10 p-r-10">
                  <span class="password-field-show">
                    <input class="password-field input-checkmark" type="password" placeholder="Re-enter Password"
                           name="password_confirmation" required autocomplete="new-password">
                    <span data-toggle=".password-field" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                  </span>
                                </div>
                            </div>
                            {{--                            <label class="label-container">I agree with <a href="signup.html#"> privacy policy</a>--}}
                            {{--                                <input type="checkbox">--}}
                            {{--                                <span class="checkmark"></span>--}}
                            {{--                            </label>--}}
                            <div class="login-btns">
                                <button type="submit">Sign up</button>
                            </div>

                            <div class="login-with-btns">

                                <span class="already-acc">Already you have an account? <a href="{{ route('login') }}" class="login-btn">Login</a></span>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

@endsection
