@extends('admin.layouts.sepienta')

@section('content')

    <section class="page-section login-page">
        <div class="full-width-screen">
            <div class="container-fluid">
                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                <div class="content-detail">
                    <!-- Forgot form -->
                    <form class="forgot-form" method="POST" action="{{ route('password.email') }}">
                        <div class="imgcontainer">
                            <img src="{{asset($logo && $logo->logo && is_file($logo->logo->path)?$logo->logo->path:'')}}" alt="logo" class="avatar w-50">
                        </div>
                        <div class="input-control">
                            <p>Enter your email, we will send a link to reset your password.</p>
                            <input type="email" placeholder="Enter your email" name="email" value="{{ old('email') }}"  autocomplete="email" autofocus class=" @error('email') is-invalid @enderror" required>
                            @error('email')
                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                            @enderror
                            <div class="login-btns">
                                <button type="submit">Reset</button>
                            </div>
                            <div class="login-with-btns">
                                <span class="already-acc">Retern to<a href="{{ route('login') }}" class="login-btn">Login</a></span>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>


@endsection
