@extends('admin.layouts.sepienta')
@section('content')
    <section class="page-section login-page">
        <div class="full-width-screen">
            <div class="container-fluid">
                <div class="content-detail">
                    <!-- Login form -->
                    <form class="login-form" method="POST" action="{{ route('login') }}" >
                        @csrf
                        <div class="imgcontainer">
                            <img src="{{asset($logo && $logo->logo && is_file($logo->logo->path)?$logo->logo->path:'')}}" alt="Avatar" class="w-50 avatar">
                        </div>
                        <div class="input-control">
                            <input type="text" placeholder="Enter Username" name="username" value="{{ old('username') }}" class="@error('username') is-invalid @enderror" autocomplete="username" autofocus required>
                            @error('username')
                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                            @enderror
                            <span class="password-field-show">
                                <input type="password" placeholder="Enter Password" name="password" required autocomplete="current-password" class="password-field @error('password') is-invalid @enderror"  value="">
                                <span data-toggle=".password-field" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                            </span>
                            @error('password')
                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                            @enderror
                            <label class="label-container">Remember me
                                <input type="checkbox">
                                <span class="checkmark"></span>
                            </label>
                            <span class="psw">
                               @if (Route::has('password.request'))
                                    <a href="{{ route('password.request') }}" class="forgot-btn">Forgot password?</a></span>
                            @endif
                            <div class="login-btns">
                                <button type="submit">Login</button>
                            </div>
                            {{--                            <div class="division-lines">--}}
                            {{--                                @if (Route::has('password.request'))--}}
                            {{--                                    <a class="forgot-btn" href="{{ route('password.request') }}">--}}
                            {{--                                        {{ __('Forgot Your Password?') }}--}}
                            {{--                                    </a>--}}
                            {{--                                @endif--}}
                            {{--                            </div>--}}
                            <div class="login-with-btns">
                                <span class="already-acc">Not a member? <a href="{{ route('register') }}" class="signup-btn">Sign up</a></span>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

@endsection
