@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        table *
        {
            /*font-size: 13px;*/
        }
        table.dataTable tbody td, table.dataTable thead td
        {
            padding: 6px!important;
        }
        table.dataTable tbody th, table.dataTable thead th
        {
            padding: 10px 6px!important;
            /*font-size: 13px!important;*/
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('user_create')
                        <a href="{{route('admin.user.create')}}" class="btn btn-primary float-left">افزودن</a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">ردیف</th>
                                <th class="border-bottom-0">نام</th>
                                <th class="border-bottom-0">دسترسی</th>
                                <th class="border-bottom-0">نام کاربری</th>
                                @can('user_status')
                                <th class="border-bottom-0">وضعیت</th>
                                @endcan
                                @canany(['user_edit','user_delete','user_access','user_fast_login'])
                                <th class="border-bottom-0">عملیات</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        {{$item->name}}
                                    </td>
                                     <td dir="ltr">
                                       {{$item->roles->first()->title}}
                                    </td>
                                    <td dir="ltr">
                                       {{$item->username}}
                                    </td>
                                    @can('user_status')
                                    <td>
                                        @if($item->status=='active')
                                            <span class="text-success ml-1">فعال</span>
                                            <a href="{{route('admin.user.status',[$item->id,'status','blocked'])}}">
                                                <i class="fa fa-close text-danger"></i>
                                            </a>
                                        @else
                                            <span class="text-danger ml-1">مسدود</span>
                                            <a href="{{route('admin.user.status',[$item->id,'status','active'])}}">
                                                <i class="fa fa-check text-success"></i>
                                            </a>
                                        @endif
                                    </td>
                                    @endcan
                                    @canany(['user_edit','user_delete','user_access','user_fast_login'])
                                        <td>
                                            <div class="d-flex">
                                                @can('user_fast_login')
                                                    <a href="{{route('admin.user.fast.login',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="fa fa-sign-in text-dark"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="ورود به پنل کاربر"></i>
                                                    </a>
                                                @endcan
                                                @can('user_access')
                                                    <a href="{{route('admin.user.edit.permission',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-lock  text-info"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="مجوز ها"></i>
                                                    </a>
                                                @endcan
                                                @can('user_edit')
                                                    <a href="{{route('admin.user.edit',$item->id)}}"
                                                       class="action-btns1">
                                                        <i class="feather feather-edit-2  text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="ویرایش"></i>
                                                    </a>
                                                @endcan

                                                    @can('user_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.user.destroy', $item->id] ]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip"
                                                            data-placement="top" title="حذف"
                                                            onclick="return confirm('برای حذف مطمئن هستید؟')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                    @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
