@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('upload_create')
                        <a href="{{route('admin.upload.create')}}" class="btn btn-primary float-left">افزودن</a>
                            @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="col-12">
                        <div class="alert alert-info text-center">
                            برای کپی کردن لینک رو کلمه "لینک" راست کلیک سپس روی <span dir="ltr"> "copy link address" </span> کلیک کنید
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">ردیف</th>
                                <th class="border-bottom-0">عنوان</th>
                                <th class="border-bottom-0">لینک</th>
                                @can('upload_delete')
                                <th class="border-bottom-0">عملیات</th>
                                    @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$item->title}}</td>
                                    <td><a href="{{url($item->file)}}" target="_blank">لینک</a></td>
                                    @can('upload_delete')
                                    <td>
                                        <div class="d-flex">
                                            {!! Form::open(['method' => 'DELETE', 'route' => ['admin.upload.destroy', $item->id] ]) !!}
                                            <button class="action-btns1" data-toggle="tooltip"
                                                    data-placement="top" title="حذف"
                                                    onclick="return confirm('برای حذف مطمئن هستید؟')">
                                                <i class="feather feather-trash-2 text-danger"></i>
                                            </button>
                                            {!! Form::close() !!}
                                        </div>
                                    </td>
                                        @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
