@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        table *
        {
        /font-size: 13px;/
        }
        table.dataTable tbody td, table.dataTable thead td
        {
            padding: 6px!important;
        }
        table.dataTable tbody th, table.dataTable thead th
        {
            padding: 10px 6px!important;
        /font-size: 13px!important;/
        }
    </style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                        {{--                        <form action="{{ route('admin.translations.process-ajax') }}" method="POST" class="d-inline">--}}
                        {{--                            @csrf--}}
                        {{--                            <button type="submit" class="btn btn-primary">--}}
                        {{--                                استخراج و ترجمه خودکار همه صفحات--}}
                        {{--                            </button>--}}
                        {{--                        </form>--}}
                    </h4>
                </div>

                <div class="card-body">
                    <button id="testTranslations" class="btn btn-primary">تست POST به process-ajax</button>
                    <pre id="translationResult" style="white-space:pre-wrap;margin-top:10px;"></pre>

                    <form action="{{ route('admin.translations.store') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="mb-3">
                            <label class="form-label">FA</label>
                            <input type="text" name="key" class="form-control">
                        </div>

                        <button type="submit" class="btn btn-sm btn-success">ذخیره</button>
                    </form>
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">ردیف</th>
                                <th class="border-bottom-0">id</th>
                                <th class="border-bottom-0">متن اصلی</th>
                                <th class="border-bottom-0">ترجمه‌ها</th>
                                <th class="border-bottom-0">عملیات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{ $item->id }}</td>
                                    <td>{{ $item->key }}</td>
                                    <td>
                                        <form action="{{ route('admin.translations.update', $item->id) }}" method="POST">
                                            @csrf
                                            @method('PUT')

                                            @foreach(['en' => 'EN', 'fr' => 'FR'] as $lang => $name)
                                                <div class="mb-3">
                                                    <label class="form-label">{{ $name }}</label>
                                                    <input type="text" name="translations[{{ $lang }}]"
                                                           value="{{ $item->translations[$lang] ?? '' }}"
                                                           class="form-control">
                                                </div>
                                            @endforeach

                                            <button type="submit" class="btn btn-sm btn-success">ذخیره</button>
                                        </form>
                                    </td>
                                    <td>
                                        <!-- عملیات اضافی -->
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
@push('in_tag_script')
    {{--    <script src="{{url('assets/admin/js/translations.js')}}"></script>--}}
    <script src="{{url('assets/admin/js/translation-processor.js')}}"></script>
        <script>
            document.getElementById('testTranslations').addEventListener('click', async function () {
                const url = window.translationProcessUrl || "{{ route('admin.translations.process-ajax') }}";
                const tokenMeta = document.querySelector('meta[name="csrf-token"]');
                const csrf = tokenMeta ? tokenMeta.getAttribute('content') : '';

                // payload را مطابق انتظارات کنترلرت تغییر بده
                const payload = { test: 1 };

                try {
                    const res = await fetch(url, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrf,
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify(payload)
                    });

                    let out;
                    try { out = await res.json(); } catch(e) { out = await res.text(); }

                    document.getElementById('translationResult').textContent =
                        'status: ' + res.status + '\n' + JSON.stringify(out, null, 2);
                } catch (err) {
                    document.getElementById('translationResult').textContent = 'Error: ' + err.message;
                }
            });
        </script>
    @endpush
