@extends('admin.layouts.app',['tbl'=>true])

@section('content')
<style>
    .box_sh
    {
        box-shadow:0 0 2px 0 #66666650;
        border-radius:3px;
    }
    .box_sh label
    {
        font-size: 12px;
    }
</style>
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">ردیف</th>
                                <th class="border-bottom-0">عنوان</th>
                                <th class="border-bottom-0">لوگو</th>
                                <th class="border-bottom-0">آیکون</th>
                                @can('setting_edit')
                                <th class="border-bottom-0">عملیات</th>
                                    @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$item->title}}</td>
                                    <td>
                                        @if($item->logo && is_file($item->logo->path))
                                            <img src="{{url($item->logo->path)}}" height="100px">
                                        @else
                                            ثبت نشده
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->icon && is_file($item->icon->path))
                                            <img src="{{url($item->icon->path)}}" height="100px">
                                        @else
                                            ثبت نشده
                                        @endif
                                    </td>
                                    @can('setting_edit')
                                    <td>
                                        <div class="d-flex">
                                            <a href="{{route('admin.setting.edit',$item->id)}}"
                                               class="action-btns1">
                                                <i class="feather feather-edit-2  text-success"
                                                   data-toggle="tooltip" data-placement="top"
                                                   title="ویرایش"></i>
                                            </a>
                                        </div>
                                    </td>
                                        @endcan
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
