@extends('admin.layouts.app',['req'=>true,'date_picker'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.setting.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, ' عنوان')}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang, read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'description':'description_'.$lang->lang, ' توضیحات سئو')}}
                                                    {{Form::text($lang->status=='default'?'description':'description_'.$lang->lang, read_lang($item,'description',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'keywords':'keywords_'.$lang->lang, ' کلمات کلیدی')}}
                                                    {{Form::text($lang->status=='default'?'keywords':'keywords_'.$lang->lang, read_lang($item,'keywords',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('logo', 'تصویر لوگو ')}}
                                {{Form::file('logo', array('class' => 'dropify','data-height'=>'180','accept' => '.png,.webp','id' => $item->logo ? $item->logo->id : 0 ,'data-default-file'=>$item->logo && is_file($item->logo->path)?url($item->logo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 256KB می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,WEBP باشد</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id="photos">
                                {{Form::label('icon', 'تصویر فاوآیکون ')}}
                                {{Form::file('icon', array('class' => 'dropify','data-height'=>'180','accept' => '.png,.ico,.webp','id' => $item->icon ? $item->icon->id : 0 ,'data-default-file'=>$item->icon && is_file($item->icon->path)?url($item->icon->path):null))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 256KB می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,ICO,WEBP باشد</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group" id="photos">
                                {{Form::label('header', 'تصویرهدر ')}}
                                {{Form::file('header', array('class' => 'dropify','data-height'=>'180','accept' => '.png,.jpg,.webp','id' => $item->header ? $item->header->id : 0 ,'data-default-file'=>$item->header && is_file($item->header->path)?url($item->header->path):null))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,WEBP باشد</small></p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('ویرایش',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>
@endsection
