@extends('admin.layouts.app',['req'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.redirect.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    @if($type == 410)
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('title', ' عنوان *')}}
                                    {{Form::text('title', null, array('class' => 'form-control','required'))}}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('status', 'وضعیت  *')}}
                                    {{ Form::select('status', ['active'=>'انتشار','pending'=>'عدم انتشار'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('type', 'روش  *')}}
                                    {{ Form::select('type', [410=>410,404=>404], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('from', 'لینک صفحه *')}}
                                    {{Form::url('from', null, array('class' => 'form-control d-ltr text-left'))}}
                                </div>
                            </div>

                            <div class="col-md-12 text-left">
                                <hr/>
                                {{Form::submit('افزودن',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                            </div>
                        </div>
                    @elseif($type == 301)
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('title', ' عنوان *')}}
                                    {{Form::text('title', null, array('class' => 'form-control','required'))}}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('status', 'وضعیت  *')}}
                                    {{ Form::select('status', ['active'=>'انتشار','pending'=>'عدم انتشار'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('type', 'روش  *')}}
                                    {{ Form::select('type', [301=>301,302=>302], null, array('class' => 'form-control select2-show-search custom-select')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('groups', 'گروهی *')}}
                                    {{ Form::select('groups', ['no'=>'خیر','yes'=>'بلی'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                    <p class="text-danger mt-0 mb-3" style="font-size: 12px"><small>_</small>فقط روی روش 301 اعمال می شود</p>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('from', 'از لینک *')}}
                                    {{Form::url('from', null, array('class' => 'form-control d-ltr text-left'))}}
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('to', 'به لینک *')}}
                                    {{Form::url('to', null, array('class' => 'form-control d-ltr text-left'))}}
                                </div>
                            </div>

                            <div class="col-md-12 text-left">
                                <hr/>
                                {{Form::submit('افزودن',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                            </div>
                        </div>
                    @endif

                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>


@endsection
