@extends('admin.layouts.app',['tbl'=>true,'req'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    <div class="container-fluid">
                        {{ Form::open(array('route' => ['admin.product.attr.store',$id], 'method' => 'POST','class'=>'row','id'=>'form_req','files'=>true)) }}
                        {{Form::hidden('type', $type)}}

                        @if($type == 'icon')
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{Form::label('icon', 'آیکون *')}}
                                    {{Form::file('icon', array('class' => 'dropify','data-height'=>'180','accept' => '.png,.webp','required'))}}
                                </div>
                                <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                                <p class="text-danger">_<small>بهترین سایز آیکون عرض 200 پیکسل در ارتفاع 200 پیکسل می
                                        باشد</small></p>
                                <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,WEBP باشد</small></p>
                            </div>
                        @endif
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                        id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, 'وضعیت  *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>'عدم انتشار','active'=>'انتشار'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            @if($type == 'text')
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, 'عنوان ')}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'value':'value_'.$lang->lang, 'متن ')}}
                                                    {{Form::text($lang->status=='default'?'value':'value_'.$lang->lang,null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('افزودن',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    {{ Form::close() }}
                    </div>
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">ردیف</th>
                                <th class="border-bottom-0">{{$type == 'icon' ? 'آیکون' : 'عنوان'}}</th>
                                <th class="border-bottom-0">مقدار</th>
                                <th class="border-bottom-0">ترتیب</th>
                                <th class="border-bottom-0">حذف</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        @if($type == 'icon')
                                            <img src="{{url($item->title)}}" style="width: 100px;height: 100px;object-fit: contain">
                                        @else
                                        {{$item->title}}
                                        @endif
                                    </td>
                                    <td>
                                        {{$item->value}}
                                    </td>
                                    <td>
                                        {!! Form::open(['method' => 'POST', 'route' => ['admin.product.attr.sort', $item->id] ]) !!}
                                        <input type="number" name="sort" class="form-control w-60px"
                                               value="{{$item->sort}}" onchange="return this.form.submit()">
                                        {!! Form::close() !!}
                                    </td>
                                    <td>
                                        {!! Form::open(['method' => 'DELETE', 'route' => ['admin.product.attr.destroy', $item->id] ]) !!}
                                        <button class="action-btns1" data-toggle="tooltip"
                                                data-placement="top" title="حذف"
                                                onclick="return confirm('برای حذف مطمئن هستید؟')">
                                            <i class="feather feather-trash-2 text-danger"></i>
                                        </button>
                                        {!! Form::close() !!}
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
