@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.service.update',$item->id),'id'=>'form_req', 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}"
                                            id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, 'وضعیت  *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>'عدم انتشار','active'=>'انتشار'], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, 'عنوان ')}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang,read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'icon':'icon_'.$lang->lang, 'نام ایکون ')}}
                                                    {{Form::text($lang->status=='default'?'icon':'icon_'.$lang->lang,read_lang($item,'icon',$lang->lang), array('class' => 'form-control'))}}

                                                    <p class="text-danger">_<small>مثل نمونه: fa-user</small></p>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                    {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, 'متن ')}}
                                                      <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label('sort', 'ترتیب ')}}
                                                    {{Form::number($lang->status=='default'?'sort':'sort_'.$lang->lang,read_lang($item,'sort',$lang->lang), array('class' => 'form-control d-ltr text-left'))}}

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
{{--                        <div class="col-md-6">--}}
{{--                            <div class="form-group" id="photos">--}}
{{--                                {{Form::label('photo', 'تصویر ')}}--}}
{{--                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.png,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}--}}
{{--                            </div>--}}
{{--                            <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>--}}
{{--                            <p class="text-danger">_<small>بهترین سایز تصویر عرض 600 پیکسل در ارتفاع 400 پیکسل می--}}
{{--                                    باشد</small></p>--}}
{{--                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,JPG,JPEG,WEBP باشد</small></p>--}}
{{--                        </div>--}}
{{--                        <div class="col-md-6">--}}
{{--                            <div class="form-group" id="photos">--}}
{{--                                {{Form::label('icon', 'icon ')}}--}}
{{--                                {{Form::file('icon', array('class' => 'dropify','data-height'=>'180','accept' => '.png,.webp','id' => $item->icon ? $item->icon->id : 0,'data-default-file'=>$item->icon && is_file($item->icon->path)?url($item->icon->path):null))}}--}}
{{--                                <p class="text-danger">_<small>مثل نمونه: fa-user</small></p>--}}
{{--                            </div>--}}
{{--                            <p class="text-danger">_<small>حداکثر حجم تصویر 256KB می باشد</small></p>--}}
{{--                            <p class="text-danger">_<small>بهترین سایز تصویر عرض 100 پیکسل در ارتفاع 100 پیکسل می--}}
{{--                                    باشد</small></p>--}}
{{--                            <p class="text-danger">_<small>فرمت تصویر فقط باید PNG,WEBP باشد</small></p>--}}
{{--                        </div>--}}

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('ویرایش',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>

@endsection
@push('in_tag_script')

@endpush
