@extends('admin.layouts.app',['req'=>true,'editor'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.faq.update',$item->id),'id'=>'form_req', 'method' => 'PATCH')) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        {{Form::label('status', 'وضعیت  *')}}
                                        {{ Form::select('status', ['pending'=>'عدم انتشار','active'=>'انتشار'], $item->status, array('class' => 'form-control select2-show-search custom-select','required')) }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        @if(count($categories) > 0)
                                            {{ Form::label('parent_id', 'نام والد ') }}

                                            {{ Form::select(
                                                'parent_id',
                                                [null => 'بدون والد'] + $categories->pluck('title', 'id')->toArray(),
                                                null,
                                                ['class' => 'form-control select2-show-search custom-select']
                                            ) }}
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4" id="child_wrapper" style="{{ $item->category_id == null ? 'display: none;' : '' }}">
                                    <div class="form-group">
                                        {{ Form::label('category_id', 'زیر دسته') }}
                                        {{ Form::select(
                                            'category_id',
                                            [null => 'ابتدا دسته اصلی را انتخاب کنید'],
                                            $item->category_id,
                                            ['class' => 'form-control select2-show-search custom-select', 'id' => 'child_id']
                                        ) }}
                                    </div>
                                </div>
                            </div>
                            @foreach(tab_langs() as $lang)

                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'question':'question_'.$lang->lang, ' عنوان')}}
                                                    {{Form::text($lang->status=='default'?'question':'question_'.$lang->lang, read_lang($item,'question',$lang->lang), array('class' => 'form-control',))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'answer':'answer_'.$lang->lang, 'جواب * ')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'answer':'answer_'.$lang->lang, read_lang($item,'answer',$lang->lang), array('class' => 'form-control textarea_'.$lang->align ,'required'))}}
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>


                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('ویرایش',array('class'=>'btn btn-primary','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>


@endsection
@push('in_tag_script')
    <script src="{{ url('assets/editor/laravel-ckeditor/ckeditor.js') }}"></script>
    <script src="{{ url('assets/editor/laravel-ckeditor/adapters/jquery.js') }}"></script>
    <script type="text/javascript">
        var textareaOptions = {
            filebrowserImageBrowseUrl: '{{ url('filemanager?type=Images') }}',
            filebrowserImageUploadUrl: '{{ url('filemanager/upload?type=Images&_token=') }}',
            filebrowserBrowseUrl: '{{ url('filemanager?type=Files') }}',
            filebrowserUploadUrl: '{{ url('filemanager/upload?type=Files&_token=') }}',
            language: 'fa'
        };
        $('.textarea').ckeditor(textareaOptions);

        $(document).ready(function() {
            $('#parent_id').on('change', function () {
                let parent_id = $(this).val();

                if (parent_id) {
                    $.ajax({
                        url: "{{ route('admin.faq.get.children') }}",
                        type: "POST",
                        data: {
                            parent_id: parent_id,
                            _token: "{{ csrf_token() }}"
                        },
                        success: function (data) {
                            if (Object.keys(data).length > 0) {
                                $('#child_id').empty().append('<option value="">انتخاب کنید</option>');
                                $.each(data, function (id, title) {
                                    $('#child_id').append('<option value="'+ id +'">'+ title +'</option>');
                                });
                                $('#child_wrapper').show(); // نمایش بده
                            } else {
                                $('#child_wrapper').hide(); // اگه زیر دسته‌ای نبود مخفی کن
                            }
                        }
                    });
                } else {
                    $('#child_wrapper').hide(); // اگه دسته اصلی انتخاب نشد مخفی باشه
                    $('#child_id').empty().append('<option value="">ابتدا دسته اصلی را انتخاب کنید</option>');
                }
            });
        });
    </script>
@endpush
