@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.blog.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, 'وضعیت  *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>'عدم انتشار','active'=>'انتشار'], null, array('class' => 'form-control select2-show-search custom-select','data-placeholder'=>'انتخاب کنید',)) }}
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, ' عنوان')}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'author':'author_'.$lang->lang, ' نویسنده')}}

                                                    {{Form::label('author_id', 'نویسنده ')}}
                                                    {{ Form::select(
                                                         $lang->status == 'default' ? 'author_id' : 'author_id_' . $lang->lang,
                                                         $users->pluck('name', 'id')->toArray(),
                                                         null,
                                                         ['class' => 'form-control select2-show-search custom-select', 'placeholder' => 'انتخاب کنید', 'required']
                                                     ) }}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'excerpt':'excerpt_'.$lang->lang, 'متن کوتاه مقاله')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'excerpt':'excerpt_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, 'متن مقاله')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                {{Form::label($lang->status=='default'?'quotation':'quotation_'.$lang->lang, 'نقل قول')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'quotation':'quotation_'.$lang->lang, null,  ['class' => 'form-control', 'rows' => 2])}}
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                {{Form::label($lang->status=='default'?'contents':'contents_'.$lang->lang, 'سخن اخر')}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'contents':'contents_'.$lang->lang, null,  ['class' => 'form-control', 'rows' => 2])}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, ' عنوان صفحه(سئو)')}}
                                                    {{Form::text($lang->status=='default'?'meta_title':'meta_title_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, ' توضیحات(سئو)')}}
                                                    {{Form::text($lang->status=='default'?'meta_description':'meta_description_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('category_id', 'دسته')}}
                                {{ Form::select(
                                     'category_id' ,
                                    $categories->pluck('title', 'id')->toArray(),
                                    null,
                                    ['class' => 'form-control select2-show-search custom-select', 'placeholder' => 'انتخاب کنید', 'required']
                                ) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('reading_time', 'مدت زمان مطالعه ')}}
                                {{Form::number('reading_time',null, array('class' => 'form-control d-ltr text-left','required'))}}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('tags', 'برچسب ها')}}
                                {{ Form::select('tags[]', array_pluck($tags, 'title', 'id'), null, array('class' => 'form-control select2-show-search custom-select','multiple','data-placeholder'=>'انتخاب کنید')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('slug', 'اسلاگ  *')}}
                                {{ Form::text('slug', null, array('class' => 'form-control slug_input','data-placeholder'=>'انتخاب کنید','required')) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('telegram', 'تلگرام')}}
                                {{Form::url('telegram',  null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://t.me/TelegramId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('instagram', 'اینستاگرام')}}
                                {{Form::url('instagram', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://instagram.com/InstagramId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('facebook', 'فیسبوک')}}
                                {{Form::url('facebook', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.facebook.com/FacebookId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('twitter', 'توئیتر')}}
                                {{Form::url('twitter',  null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://twitter.com/TwitterId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('linkedin', 'لینکدین')}}
                                {{Form::url('linkedin', null, array('class' => 'form-control d-ltr text-left'))}}
                            </div>
                            <p class="text-danger">_<small>لینک شبکه اجتماعی را مانند مثال ذیل وارد کنید</small></p>
                            <p class="text-danger">_<small dir="ltr">https://www.linkedin.com/in/linkedinId</small></p>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('photo', 'تصویر * ')}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','required'))}}
                            </div>
                            <p class="text-danger">_<small>حداکثر حجم تصویر 512KB می باشد</small></p>
                            <p class="text-danger">_<small>بهترین سایز تصویر معادل عرض 300 پیکسل در ارتفاع 280 پیکسل می باشد</small></p>
                            <p class="text-danger">_<small>فرمت تصویر فقط باید JPG,JPEG,WEBP باشد</small></p>
                        </div>

                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit('افزودن',array('class'=>'btn btn-primary'))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
