@extends('admin.layouts.app',['tbl'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="w-100">
            {{$title}}
            @can('permission_cat_create')
            <a href="{{route('admin.permission-cat.create')}}" class="btn btn-primary float-left">افزودن</a>
              @endcan
          </h4>
        </div>

        <div class="card-body">
          <div class="table-responsive">
            <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
              <thead>
              <tr>
                <th class="border-bottom-0">ردیف</th>
                <th class="border-bottom-0">نام جدول</th>
                <th class="border-bottom-0">سورت</th>
                <th class="border-bottom-0">ابتدای کد دسترسی</th>
                <th class="border-bottom-0">کد دسترسی نمایش</th>
                @canany(['permission_cat_edit','permission_cat_delete'])
                  <th class="border-bottom-0">عملیات</th>
                @endcan
              </tr>
              </thead>
              <tbody>
              @foreach($items as $key=>$item)
                <tr>
                  <td>{{$key+1}}</td>
                  <td>{{$item->table_name}}</td>
                  <td>{{$item->sort_by}}</td>
                  <td>{{$item->access_list_code}}</td>
                  <td>{{$item->access_code}}</td>
                  @canany(['permission_cat_edit','permission_cat_delete'])
                    <td>
                      <div class="d-flex">
                        @can('permission_cat_edit')
                          <a href="{{route('admin.permission-cat.edit',$item->id)}}"
                             class="action-btns1" data-bs-toggle="tooltip" data-bs-html="true"  data-bs-placement="top"
                             title="<b>ویرایش</b>">
                            <i class="fa fa-edit  text-success"></i>
                          </a>
                        @endcan
                        @can('permission_cat_delete')
                          {!! Form::open(['method' => 'DELETE', 'route' => ['admin.permission-cat.destroy', $item->id] ]) !!}
                          <button class="action-btns1" data-bs-toggle="tooltip" data-bs-html="true"
                                  data-bs-placement="top" title="<b>حذف</b>"
                                  onclick="return confirm('برای حذف مطمئن هستید؟')">
                            <i class="fa fa-trash text-danger"></i>
                          </button>
                          {!! Form::close() !!}
                        @endcan
                      </div>
                    </td>
                  @endcan
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
