@extends('admin.layouts.app',['req'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <hr>

        <div class="card-body">
          {{ Form::open(array('route' => 'admin.permission.store', 'method' => 'POST','id'=>'form_req')) }}
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('category_id', 'دسته بندی(جدول) *')}}
                <select name="category_id"
                        class="form-control select2-show-search select_prefix custom-select"
                        data-placeholder="انتخاب کنید" required>
                  <option value="">انتخاب کنید</option>
                  @foreach($cats as $cat)
                    <option value="{{$cat->id}}"
                            {{old('category_id')==$cat->id?'selected':''}} data-prefix="{{$cat->access_code}}">{{$cat->table_name}}</option>
                  @endforeach
                </select>
                {{--                                {{ Form::select('category_id', array_pluck($cats, 'table_name', 'id',['','انتخاب کنید']), null, array('class' => 'form-control select2-show-search select_prefix custom-select','data-placeholder'=>'انتخاب کنید','required')) }}--}}
              </div>
            </div>
            <div class="col-md-6"></div>
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('title', 'عنوان دسترسی *')}}
                {{Form::text('title', null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                {{Form::label('name', 'کد دسترسی *')}}
                {{Form::text('name', null, array('class' => 'form-control prefix_input d-ltr text-left','required'))}}
                <span class="prefix_span"></span>
              </div>
            </div>
            <div class="col-md-12">
              <hr/>
              {{Form::submit('افزودن',array('class'=>'btn btn-primary float-left','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
            </div>
          </div>
          {{ Form::close() }}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('in_tag_script')
  @if(old('categroy_id'))
    <script>
        $(document).ready(function () {
            var prefix=$('.select_prefix').find(':selected').attr('data-prefix')
            $('.prefix_span').text(prefix+'_')
            var w_prefix=$('.prefix_span').outerWidth();
            $('.prefix_input').css('padding-left',w_prefix+'px')
        })
    </script>
  @endif
@endpush
