<?php

use App\Http\Middleware\ConvertEmptyStringsToNull;
use App\Http\Middleware\ConvertToEnNum;
use App\Http\Middleware\LowerCaseUrl;
use App\Http\Middleware\RedirectMidd;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRedirectFilter;
use Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRoutes;
use Mcamara\LaravelLocalization\Middleware\LaravelLocalizationViewPath;
use Mcamara\LaravelLocalization\Middleware\LocaleCookieRedirect;
use Mcamara\LaravelLocalization\Middleware\LocaleSessionRedirect;
use Spatie\Permission\Middleware\PermissionMiddleware;
use Spatie\Permission\Middleware\RoleMiddleware;
use Spatie\Permission\Middleware\RoleOrPermissionMiddleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
    web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
        then: function () {
    Route::namespace('App\\Http\\Controllers')
        ->prefix(LaravelLocalization::setLocale())
        ->name('front.')
        ->middleware(['web', 'LowerCaseUrl', 'RedirectMidd', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'])
        ->group(base_path('routes/front.php'));

    Route::namespace('App\\Http\\Controllers')
        ->prefix('admin/')
        ->name('admin.')
        ->middleware(['web', 'auth','localeSessionRedirect', 'localizationRedirect', 'localeViewPath'])
        ->group(base_path('routes/admin.php'));
}
    )
    ->withMiddleware(function (Middleware $middleware) {
    $middleware->validateCsrfTokens(except: [
        'filemanager/upload' // <-- exclude this route
    ]);
        $middleware->alias([
            'Html' => Spatie\Html\Facades\Html::class,
            'Excel' => Maatwebsite\Excel\Facades\Excel::class,
            'role' => RoleMiddleware::class,
            'permission' => PermissionMiddleware::class,
            'role_or_permission' => RoleOrPermissionMiddleware::class,
            'localize' => LaravelLocalizationRoutes::class,
            'localizationRedirect' => LaravelLocalizationRedirectFilter::class,
            'localeSessionRedirect' => LocaleSessionRedirect::class,
            'localeCookieRedirect' => LocaleCookieRedirect::class,
            'localeViewPath' => LaravelLocalizationViewPath::class,
            'LowerCaseUrl' => LowerCaseUrl::class,
            'RedirectMidd' => RedirectMidd::class,
            'ConvertEmptyStringsToNull' => ConvertEmptyStringsToNull::class,
            'ConvertToEnNum' => ConvertToEnNum::class,
        ]);

        $middleware->use([
            LowerCaseUrl::class,
            RedirectMidd::class,
            ConvertEmptyStringsToNull::class,
            ConvertToEnNum::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        // $exceptions->render(function ($request, Throwable $e) {
        //     //url lower
        //     $url_original = urldecode($request->path());
        //     $string = preg_match('/^[^\x{600}-\x{6FF}]+$/u', $url_original);
        //     if ($string > 0) {
        //         $url_lower = strtolower($request->path());
        //         $url = strtolower(urldecode($request->fullUrl()));
        //         $preg_match = "/uploads/";
        //         // dd($url_original != $url_lower);
        //         // بخش تصاویر را با استفاده از یک عبارت باقاعده مستثنی کنید
        //         if (!preg_match($preg_match, $url_lower) && $url_original != $url_lower) {
        //             header("Location: $url", true, 301);
        //             exit();
        //         }
        //     }
        //     //ریدایرکت
        //     $url = $request->fullUrl();
        //     $url = str_replace('http://', 'https://', $url);
        //     $url = urldecode($url);
        //     $url_slugs = str_replace(route('front.index'), '', $url);
        //     // $url_slug=explode('?',$url_slug);
        //     $url_slugs = explode('/', $url_slugs);
        //     $url_slug = $url_slugs[0];

        //     if (blank($url_slug) && count($url_slugs) > 1) {
        //         $url_slug = $url_slugs[1];
        //     }
        //     $redirect = Redirect::where('from', $url)->where('status', 'active')->first();
        //     if (is_null($redirect)) {
        //         $redirect = Redirect::where('from', $url . '/')->where('status', 'active')->first();
        //         if (is_null($redirect)) {
        //             $redirect = Redirect::where('from', explode('?', $url)[0])->where('status', 'active')->first();
        //             if (is_null($redirect)) {
        //                 $redirect = Redirect::where('from', explode('?', $url)[0] . '/')->where('status', 'active')->first();
        //                 if (is_null($redirect)) {
        //                     $redirect = Redirect::where('from', 'LIKE', '%' . $url_slug . '%')->where('groups', 'yes')->where('status', 'active')->first();
        //                 }
        //             }
        //         }
        //     }
        //     if ($redirect) {
        //         if ($redirect->type == 410) {
        //             header("HTTP/1.1 410 Gone");
        //             include('errors/410.html'); // Adjust the path to your 404.html file as needed
        //             exit();
        //         } elseif ($redirect->type == 404) {
        //             header("HTTP/1.1 404 Not Found");
        //             include('errors/404.html'); // Adjust the path to your 404.html file as needed
        //             exit();
        //         } elseif ($redirect->type == 301) {
        //             if ($redirect->groups == 'yes') {
        //                 $original_url = $request->path();
        //                 $index_url = route('front.index') . '/';
        //                 $preg_match = str_replace($index_url, '', $redirect->from);
        //                 if (stripos($original_url, $preg_match) !== false) {
        //                     header("Location: $redirect->to", true, 301);
        //                     exit();
        //                 }
        //             } else {
        //                 header("Location: $redirect->to", true, 301);
        //                 exit();
        //             }
        //         } elseif ($redirect->type == 302) {
        //             header("Location: $redirect->to", true, 302);
        //             exit();
        //         }
        //     }

        //     // ارور صفحات
        //     if ($this->isHttpException($e)) {
        //         $statusCode = $e->getStatusCode();

        //         if ($statusCode == 404) {
        //             header("HTTP/1.1 404 Not Found");
        //             include('errors/404.html'); // Adjust the path to your 404.html file as needed
        //             exit();
        //         }

        //         if ($statusCode == 410) {
        //             header("HTTP/1.1 410 Gone");
        //             include('errors/410.html'); // Adjust the path to your 404.html file as needed
        //             exit();
        //         }

        //         if ($statusCode == 500) {
        //             header("HTTP/1.1 500 Internal Server Error");
        //             include('errors/500.html'); // Adjust the path to your 404.html file as needed
        //             exit();
        //         }
        //     }

        //     return parent::render($request, $e);
        // });
    })->create();
