<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Carbon\Carbon;


class SportsEventsService
{
    protected $username = 'exp20';
    protected $password = '01uZIaBeG203';
    protected $apiKey   = '26d9f50380352ff97371bcfc0d5197f2';
    protected $baseUrl  = 'https://api-v2.sandbox365.com/';


    public function headers()
    {
        return[
            'Authorization' => 'Basic ' . base64_encode($this->username . ':' . $this->password),
        ];
    }
    public function getMajorEvents()
    {
        $response = Http::withHeaders($this->headers())
            ->get($this->baseUrl . 'events/major', [
                'apiKey' => $this->apiKey
            ]);

        return $response->json();
    }

    public function getSpecialEvents()
    {
        $response = Http::withHeaders($this->headers())
            ->get($this->baseUrl . 'events/special', [
                'apiKey' => $this->apiKey
            ]);

        return $response->json();
    }

    public function getAllEvents()
    {
        $major   = $this->getMajorEvents();
        $special = $this->getSpecialEvents();

        $allEvents = array_merge(
            $major['data'] ?? [],
            $special['data'] ?? []
        );

        return $allEvents;
    }

    public function getEvent($eventId)
    {
        $response = Http::withHeaders($this->headers())
            ->get($this->baseUrl."events/{$eventId}?apiKey={$this->apiKey}");

        return $response->json();
    }
    public function getEventTickets($eventId)
    {
        $response = Http::withHeaders($this->headers())
            ->get($this->baseUrl."tickets/{$eventId}?apiKey={$this->apiKey}");

        return $response->json();
    }



    public function filterEvents($filters =[])
    {
        $url=$this->baseUrl.'events/major/special';
        if(!empty($filters)){
            $url = $this->baseUrl.'events';
        }

        $response = Http::withHeaders($this->headers())
            ->get($url, array_merge($filters,[
                'apiKey' => $this->apiKey
            ]));
        return $response->json();
    }

    public function getCountries()
    {
        $response = Http::withHeaders($this->headers())
            ->get($this->baseUrl.'countries',[
                'apiKey' => $this->apiKey
            ]);

        return $response->json();
    }

    public function getCities($countryId)
    {
        $response = Http::withHeaders($this->headers())
            ->get($this->baseUrl."countries/{$countryId}/city/top", [
                'apiKey' => $this->apiKey
            ]);

        return $response->json();
    }

    public function getUniqueEventDates($events)
    {
        $dates = [];
        foreach ($events as $event) {
            if (isset($event['dateOfEvent']) && !in_array($event['dateOfEvent'], $dates)) {
                $dates[] = $event['dateOfEvent'];
            }
        }

        $formattedDates = [];
        foreach ($dates as $date) {
            $carbon = Carbon::createFromFormat('d/m/Y', $date);
            $formattedDates[$date] = $carbon->format('F jS, Y'); // August 2nd, 2016
        }

        return $formattedDates;
    }

    public function filterCountries($countries)
    {
        return array_filter($countries, fn($c) => $c['name'] !== 'Israeli New Shekel');
    }

    public function flexibleSearchEvents(array $filters = []): array
    {
        $events = [];

        if (!empty($filters['countryId'])) {
            $response = Http::withHeaders($this->headers())
                ->get($this->baseUrl . "events/country/{$filters['countryId']}", [
                    'apiKey' => $this->apiKey
                ]);
            $events = $response->json()['data'] ?? [];
        } else {
            $events = $this->getAllEvents();
        }

        if (!empty($filters['cityId'])) {
            $events = array_filter($events, fn($e) => ($e['city']['id'] ?? null) == $filters['cityId']);
        }

        if (!empty($filters['date'])) {
            $events = array_filter($events, fn($e) => ($e['dateOfEvent'] ?? null) == $filters['date']);
        }

        if (!empty($filters['date_range'])) {
            $from = Carbon::createFromFormat('d/m/Y', $filters['date_range']['from']);
            $to   = Carbon::createFromFormat('d/m/Y', $filters['date_range']['to']);
            $events = array_filter($events, function($e) use ($from, $to) {
                if (empty($e['dateOfEvent'])) return false;
                $eventDate = Carbon::createFromFormat('d/m/Y', $e['dateOfEvent']);
                return $eventDate->between($from, $to);
            });
        }

        if (!empty($filters['keyword'])) {
            $keyword = strtolower($filters['keyword']);
            $events = array_filter($events, function($e) use ($keyword) {
                $fields = [
                    $e['name'] ?? null,
                    $e['homeTeam']['name'] ?? null,
                    $e['awayTeam']['name'] ?? null,
                    $e['participants']['name'] ?? null,
                    $e['venue']['name'] ?? null,
                    $e['country']['name'] ?? null,
                    $e['city']['name'] ?? null,
                    $e['dateOfEvent'] ?? null,
                ];

                foreach ($fields as $field) {
                    if (!empty($field) && stripos(strtolower($field), $keyword) !== false) {
                        return true;
                    }
                }
                return false;
            });
        }

        if (!empty($filters['features'])) {
            $events = array_filter($events, fn($e) =>
                in_array('All', $filters['features']) ||
                array_intersect($filters['features'], $e['features'] ?? [])
            );
        }

        if (!empty($filters['delivery'])) {
            $events = array_filter($events, fn($e) =>
                in_array('All', $filters['delivery']) ||
                in_array($e['delivery'] ?? '', $filters['delivery'])
            );
        }

        return array_values($events);
    }



}
