<?php

namespace App\Providers;

use App\Models\ProductEncyclopedia;
use App\Models\About;
use App\Models\Contact;
use App\Models\ContactForm;
use App\Models\Meta;
use App\Models\Setting;
use App\Models\SiteWord;
use App\Models\ProductCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(Request $request)
    {
        $this->url = urldecode($request->fullUrl());

        Schema::defaultStringLength(191);

        view()->composer('admin.layouts.app', function ($view) {
            $setting = Setting::first();
            $view
                ->with('contact_form', ContactForm::where('seen', 'no')->count())
                ->with('fav_icon', $setting->icon && is_file($setting->icon->path) ? url($setting->icon->path) : url('assets/front/img/favicon.png'))
                ->with('logo', $setting->logo && is_file($setting->logo->path) ? url($setting->logo->path) : url('assets/front/img/logo.png'))
                ->with('setting', $setting);
        });

        view()->composer('front.layouts.front', function ($view) {
            $sett = Setting::first();
            $lang = '/' . app()->getLocale();
            $meta_url = str_replace($lang, '', $this->url);
            $seo = Meta::where('link', $meta_url)->checkStatus()->first();
            //ProductEncyclopedia
            $product_encyclopedias = ProductEncyclopedia::where('status_home', 'active')->checkStatus()->orderBy('sort')->get();
            if (is_null($seo)) {
                $seo = Meta::where('link', $meta_url . '/')->checkStatus()->first();
                if (is_null($seo)) {
                    $seo = Meta::where('link', explode('?', $meta_url)[0])->checkStatus()->first();
                    if (is_null($seo)) {
                        $seo = Meta::where('link', explode('?', $meta_url)[0] . '/')->checkStatus()->first();
                    }
                }
            }

            $seo_set = false;
            $schemaSeo = null;
            $canonical = explode('?',$this->url)[0];
            $robots = "index, follow";
            if (!is_null($seo)) {
                $seo_set = true;
                $titleSeo = read_lang($seo, 'title_page');
                $descriptionSeo = read_lang($seo, 'description');
                $schemaSeo = $seo->schema;
                if(!blank($seo->canonical))
                    $canonical = $seo->canonical;
                if(!blank($seo->robots))
                    $robots = $seo->robots;
            } else {
                $titleSeo = read_lang($sett, 'title');
                $descriptionSeo = read_lang($sett, 'description');
            }
            $titleSeo2 = read_lang($sett, 'title');
            $descriptionSeo2 = read_lang($sett, 'description');

            $view
                ->with('urlPage', $this->url)
                ->with('fav_icon', $sett->icon && is_file($sett->icon->path) ? url($sett->icon->path) : url('assets/front/img/favicon.png'))
                ->with('logo', $sett->logo && is_file($sett->logo->path) ? url($sett->logo->path) : url('assets/front/img/logo.png'))
                ->with('header', $sett->header && is_file($sett->header->path) ? url($sett->header->path) : url('assets/front/banner.jpg'))
                ->with('contact_info', Contact::first())
                ->with('about_footer', About::where('type', 'footer')->first())
                ->with('cats_menu', ProductCategory::checkStatus()->where('parent_id', null)->get())
                ->with('seo_set', $seo_set)
                ->with('titleSeo', $titleSeo)
                ->with('descriptionSeo', $descriptionSeo)
                ->with('titleSeo2', $titleSeo2)
                ->with('descriptionSeo2', $descriptionSeo2)
                ->with('product_encyclopedias_menu', $product_encyclopedias)
                ->with('schemaSeo', $schemaSeo)
                ->with('canonical', $canonical)
                ->with('robots', $robots);
        });

    }


}
