<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Blog;

class User extends Authenticatable
{
    use HasFactory, HasRoles, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
     protected $guarded = ['id', 'created_at', 'updated_at'];


    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function setPasswordAttribute($password)
    {
        $this->attributes['password'] = bcrypt($password);
    }
    public function user_info()
    {
        return $this->hasOne('App\Models\UserComplete', 'user_id');
    }
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }
    public function user_work()
    {
        return $this->hasOne('App\Models\UserWork', 'user_id');
    }
     public function user_token()
    {
        return $this->hasOne('App\Models\UserToken', 'user_id');
    }

    public function projects()
    {
        return $this->hasMany(ResearchProject::class);
    }

    public function instructorProfile()
    {
        return $this->hasOne(InstructorProfile::class);
    }

    public function teachingCourses()
    {
        return $this->belongsToMany(Course::class, 'course_instructors');
    }

    public function enrolledCourses()
    {
        return $this->hasMany(CourseEnrollment::class);
    }

    public function reviews()
    {
        return $this->hasMany(CourseReview::class);
    }

    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->logo->path);
                }
                $item->photo->delete();
            }
             if($item->user_work)
            {
                $item->user_work->delete();
            }
             if($item->user_token)
            {
                $item->user_token->delete();
            }
        });
    }
}
