<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Translation extends Model
{
    use HasFactory;
    protected $fillable = ['key', 'translations'];
    protected $casts = ['translations' => 'array'];

    public static function findOrCreate($key)
    {
        return static::firstOrCreate(
            ['key' => $key],
            ['translations' => []]
        );
    }

    public function addTranslation($lang, $value)
    {
        $translations = $this->translations ?? [];
        $translations[$lang] = $value;
        $this->translations = $translations;

        $saved = $this->save();

        \Log::info("Saving translation for key: {$this->key}, lang: {$lang}, success: " . ($saved ? 'yes' : 'no'));

        return $saved;
    }
}
