<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstructorProfile extends Model
{
    use HasFactory;
    protected $guarded = ['id', 'created_at', 'updated_at'];
    protected $casts = [
        'social_links' => 'array'
    ];

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    // زبان فعال بر اساس وضعیت
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')
            ->where('lang', app()->getLocale())
            ->where('col_name', 'status')
            ->where('text', 'active');
    }

    // Scope برای فیلتر کردن بر اساس وضعیت و زبان
    public function scopeCheckStatus($query)
    {
        if (default_lang() == lang()) {
            return $query->where('status', 'active');
        } else {
            return $query->whereHas('lang_active');
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {

            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }

        });
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
