<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogCategory extends Model
{
    use HasFactory;

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }
    public function blogs_active()
    {
        return $this->hasMany(Blog::class)->checkStatus();
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'status')->where('text', 'active');
    }
    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {

            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

        });
    }
}
