<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class PageHeaderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'page' => 'required|max:75',
                    'title' => 'required|max:75',
                    'subtitle' => 'nullable|max:300',
                    'text' => 'nullable|max:300',
                    'header' => "required|mimes:jpeg,jpg,png,webp,mp4,mov|max:30720",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'page' => 'required|max:75',
                    'title' => 'required|max:75',
                    'subtitle' => 'nullable|max:300',
                    'text' => 'nullable|max:300',
                    'header' => 'nullable|file|mimes:jpg,png,jpeg,gif'
                ];
            }
            default:
                break;
        }
    }
}
