<?php

namespace App\Http\Requests\Product;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'parent_id' => 'required',
                    'title' => 'required|max:255',
                    'slug' => 'required|max:255|unique:product_categories,slug',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                ];
            }
            case 'PATCH':
            {
                $id = $this->request->get('id');
                return [
                    'parent_id' => 'required',
                    'title' => 'required|max:255',
                    'slug' => 'required|max:255|unique:product_categories,slug,' . $id,
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                ];
            }
            default:
                break;
        }
    }
}
