<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ResearchProjectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|string|max:255',
                    'description' => 'required|max:2000',
                    'user_id' => 'required|exists:users,id',
                    'complete' => 'required|integer|min:0|max:100',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:2048",
                ];
            }
            case 'PATCH':
            {
                return [
                    'title' => 'required|string|max:255',
                    'description' => 'required|max:2000',
                    'user_id' => 'required|exists:users,id',
                    'complete' => 'required|integer|min:0|max:100',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:2048",
                ];
            }
            default:
                break;
        }
    }
}
