<?php

namespace App\Http\Requests\Front;

use Illuminate\Foundation\Http\FormRequest;

class commentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'description'=> ['required', 'string'],
            'parent_id'   => ['nullable', 'exists:comments,id'],
            'g-recaptcha-response' => 'required',
        ];
    }
    public function messages()
    {
        return [
            'description.required' =>  read_lang_word('required-description'),
            'name.string' => read_lang_word('format-string'),
            'g-recaptcha-response.required' => read_lang_word('not-robot'),
        ];
    }
}
