<?php

namespace App\Http\Requests\Education;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class GradeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name' => 'required|string|min:4|max:250',
                    'slug' => 'required|max:300|unique:blogs,slug',
                    'status' => 'required',
                    'sort' => 'nullable',

                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'name' => 'nullable|string|min:4|max:250',
                    'slug' => 'required|max:300|unique:blogs,slug,'.$id,
                    'status' => 'nullable',
                    'sort' => 'nullable',

                ];
            }
            default:
                break;
        }
    }
}
