<?php

namespace App\Http\Requests\Education;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class CourseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|string|min:4|max:250',
                    'instructor_id' => 'required|array',
                    'description' => 'required|string',
                    'language' => 'required|string',
                    'level' => 'required|string',
                    'access_type' => 'required|string',
                    'private_message' => 'nullable|string',
                    'category_id' => 'required|string',
                    'start_date' => 'required|date',
                    'duration_weeks' => 'required',
                    'price' => 'required|numeric',
                    'certificate_included' => 'nullable',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:2048",
                    'video' => "nullable|file|mimes:mp4,mkv,webm,mov|max:30720",

                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|string|min:4|max:250',
                    'instructor_id' => 'nullable|array',
                    'description' => 'required|string',
                    'language' => 'required|string',
                    'level' => 'required|string',
                    'access_type' => 'required|string',
                    'private_message' => 'nullable|string',
                    'category_id' => 'required|string',
                    'start_date' => 'required|date',
                    'duration_weeks' => 'required',
                    'price' => 'required|numeric',
                    'certificate_included' => 'nullable',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:2048",
                    'video' => "nullable|file|mimes:mp4,mkv,webm,mov|max:30720",
                ];
            }
            default:
                break;
        }
    }
}
