<?php

namespace App\Http\Requests\Access;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
class RoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:250|unique:roles',
                    'name' => 'required|max:190|unique:roles',
//                    'permission' => 'required',
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                 $user_id=$this->request->get('user_id');
                 if(Auth::id()==$user_id || Auth::user()->HasRole('developer'))
                {
                    return [
                    'title' => 'required|max:250|unique:roles,title,'.$id,
                    'name' => 'required|max:191|unique:roles,name,'.$id,
//                    'permission' => 'required',
                ];
                }
                else{
                 return [
                    'title' => 'nullable|max:250|unique:roles,title,'.$id,
                    'name' => 'nullable|max:191|unique:roles,name,'.$id,
                ];
                }
            }
            default:
                break;
        }
    }
}
